/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model;

import java.math.BigInteger;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.data.MeasurementType;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionLanguage;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.io.bpmn.jaxb.TActivity;
import oracle.bpm.project.io.bpmn.jaxb.TArtifact;
import oracle.bpm.project.io.bpmn.jaxb.TAssignment;
import oracle.bpm.project.io.bpmn.jaxb.TAttributeExpression;
import oracle.bpm.project.io.bpmn.jaxb.TBaseElement;
import oracle.bpm.project.io.bpmn.jaxb.TBaseElementWithMixedContent;
import oracle.bpm.project.io.bpmn.jaxb.TBoundaryEvent;
import oracle.bpm.project.io.bpmn.jaxb.TBusinessIndicator;
import oracle.bpm.project.io.bpmn.jaxb.TBusinessIndicators;
import oracle.bpm.project.io.bpmn.jaxb.TBusinessRuleTask;
import oracle.bpm.project.io.bpmn.jaxb.TCallActivity;
import oracle.bpm.project.io.bpmn.jaxb.TCatchEvent;
import oracle.bpm.project.io.bpmn.jaxb.TComplexGateway;
import oracle.bpm.project.io.bpmn.jaxb.TCounter;
import oracle.bpm.project.io.bpmn.jaxb.TDataAssociation;
import oracle.bpm.project.io.bpmn.jaxb.TDataInput;
import oracle.bpm.project.io.bpmn.jaxb.TDataInputAssociation;
import oracle.bpm.project.io.bpmn.jaxb.TDataObject;
import oracle.bpm.project.io.bpmn.jaxb.TDataOutput;
import oracle.bpm.project.io.bpmn.jaxb.TDataOutputAssociation;
import oracle.bpm.project.io.bpmn.jaxb.TDefinitions;
import oracle.bpm.project.io.bpmn.jaxb.TEndEvent;
import oracle.bpm.project.io.bpmn.jaxb.TErrorEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TEvent;
import oracle.bpm.project.io.bpmn.jaxb.TEventBasedGateway;
import oracle.bpm.project.io.bpmn.jaxb.TEventBasedGatewayType;
import oracle.bpm.project.io.bpmn.jaxb.TEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TExclusiveGateway;
import oracle.bpm.project.io.bpmn.jaxb.TFlowElement;
import oracle.bpm.project.io.bpmn.jaxb.TFormalExpression;
import oracle.bpm.project.io.bpmn.jaxb.TGateway;
import oracle.bpm.project.io.bpmn.jaxb.TGatewayDirection;
import oracle.bpm.project.io.bpmn.jaxb.TInclusiveGateway;
import oracle.bpm.project.io.bpmn.jaxb.TInputOutputSpecification;
import oracle.bpm.project.io.bpmn.jaxb.TInputSet;
import oracle.bpm.project.io.bpmn.jaxb.TIntermediateCatchEvent;
import oracle.bpm.project.io.bpmn.jaxb.TIntermediateThrowEvent;
import oracle.bpm.project.io.bpmn.jaxb.TLoopCharacteristics;
import oracle.bpm.project.io.bpmn.jaxb.TManualTask;
import oracle.bpm.project.io.bpmn.jaxb.TMeasurementMark;
import oracle.bpm.project.io.bpmn.jaxb.TMessageEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TMultiInstanceFlowCondition;
import oracle.bpm.project.io.bpmn.jaxb.TMultiInstanceLoopCharacteristics;
import oracle.bpm.project.io.bpmn.jaxb.TOutputSet;
import oracle.bpm.project.io.bpmn.jaxb.TParallelGateway;
import oracle.bpm.project.io.bpmn.jaxb.TPeopleGroup;
import oracle.bpm.project.io.bpmn.jaxb.TPerformer;
import oracle.bpm.project.io.bpmn.jaxb.TProcess;
import oracle.bpm.project.io.bpmn.jaxb.TProcessType;
import oracle.bpm.project.io.bpmn.jaxb.TReceiveTask;
import oracle.bpm.project.io.bpmn.jaxb.TScript;
import oracle.bpm.project.io.bpmn.jaxb.TScriptTask;
import oracle.bpm.project.io.bpmn.jaxb.TSendTask;
import oracle.bpm.project.io.bpmn.jaxb.TSequenceFlow;
import oracle.bpm.project.io.bpmn.jaxb.TServiceTask;
import oracle.bpm.project.io.bpmn.jaxb.TSignalEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TStandardLoopCharacteristics;
import oracle.bpm.project.io.bpmn.jaxb.TStartEvent;
import oracle.bpm.project.io.bpmn.jaxb.TSubProcess;
import oracle.bpm.project.io.bpmn.jaxb.TTask;
import oracle.bpm.project.io.bpmn.jaxb.TText;
import oracle.bpm.project.io.bpmn.jaxb.TTextAnnotation;
import oracle.bpm.project.io.bpmn.jaxb.TThrowEvent;
import oracle.bpm.project.io.bpmn.jaxb.TTimerEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TUserTask;
import oracle.bpm.project.io.bpmn.jaxb.TUserTaskImplementation;
import oracle.bpm.project.io.bpmn.jaxb.extensions.ObjectFactory;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TAnnotations;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBooleanFeature;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBusinessAttributes;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBusinessDataRange;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBusinessRuleTaskData;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TDataAssignment;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TDataObjectType;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TExpression;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TExternalTransformation;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TFeatureSet;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TGraphicsAttributes;
import oracle.bpm.project.io.bpmn.jaxb.extensions.THiddenAnnotations;
import oracle.bpm.project.io.bpmn.jaxb.extensions.THumanTask;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TIntegerFeature;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TLocalization;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TLocalizedContent;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TLocalizedItemsContainer;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TOracleExtensions;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TParticipant;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TPosition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TSequenceFlowAttributes;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TSize;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TStringFeature;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TTypeRef;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TUserAnnotations;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectVisitorAdapter;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.catalog.FaultObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.catalog.SignalObject;
import oracle.bpm.project.model.catalog.SystemFaultObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.AnnotationsFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.InOutDataAssociationFeature;
import oracle.bpm.project.model.features.IncludesStoredI18n;
import oracle.bpm.project.model.features.IncomingDataAssociationFeature;
import oracle.bpm.project.model.features.OutgoingDataAssociationFeature;
import oracle.bpm.project.model.features.PersistentFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Artifact;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.CheckedEventTriggerAdapter;
import oracle.bpm.project.model.processes.CheckedFlowNodeAdapter;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.DataElementScope;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.InputArgumentsEnabled;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Loop;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.ManualTask;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.MessageEventDefinition;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.OutputArgumentsEnabled;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.SignalEventDefinition;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.TimerEventDefinition;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItemRef;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class ProcessVisitor
extends ProjectVisitorAdapter {
    private List<TArtifact> currentArtifactList;
    private List<JAXBElement<? extends TFlowElement>> currentElementList;
    private TFeatureSet currentFeatureSet;
    private TDefinitions definitions;
    private ObjectFactory extensionsFactory = new ObjectFactory();
    private oracle.bpm.project.io.bpmn.jaxb.ObjectFactory objectFactory = new oracle.bpm.project.io.bpmn.jaxb.ObjectFactory();
    private TProcess tProcess;
    private static final String BPMN_NS = "http://www.omg.org/bpmn20";

    public JAXBElement<TDefinitions> getDefinitions() {
        return this.objectFactory.createDefinitions(this.definitions);
    }

    @Override
    public void visit(Process process) throws ProjectException {
        this.definitions = this.objectFactory.createTDefinitions();
        this.tProcess = this.objectFactory.createTProcess();
        this.tProcess.setId(process.getId());
        this.tProcess.setName(process.getId());
        this.tProcess.setProcessType(TProcessType.EXECUTABLE);
        this.addRolesDefinitions(process);
        this.currentElementList = this.tProcess.getFlowElement();
        this.currentArtifactList = this.tProcess.getArtifact();
        this.visitFlowElements(process);
        this.visitArtifacts(process);
        this.fillOracleExtensions(process);
        this.fillProcessIoSpecification(process);
        this.definitions.getRootElement().add(this.objectFactory.createProcess(this.tProcess));
    }

    @Override
    public void visit(Activity activity) throws ProjectException {
        PersistenceFlowNodeHandler persistenceFlowNodeHandler = new PersistenceFlowNodeHandler(this.currentElementList);
        ModelUtils.handleFlowNodeChecked(activity, persistenceFlowNodeHandler);
        TActivity tActivity = persistenceFlowNodeHandler.getActivityRef();
        if (tActivity != null) {
            this.fillActivityAttributes(tActivity, activity);
            this.fillOracleExtensions(tActivity, activity);
            this.fillActivityIoSpecification(tActivity, activity);
        }
    }

    @Override
    public void visit(Event event) throws ProjectException {
        PersistenceFlowNodeHandler persistenceFlowNodeHandler = new PersistenceFlowNodeHandler(this.currentElementList);
        ModelUtils.handleFlowNodeChecked(event, persistenceFlowNodeHandler);
        TEvent tEvent = persistenceFlowNodeHandler.getEventRef();
        if (tEvent != null) {
            this.fillEventAttributes(tEvent, event);
            this.fillOracleExtensions(tEvent, event);
            this.fillEventTrigger(tEvent, event);
        }
    }

    @Override
    public void visit(BoundaryEvent boundaryEvent) throws ProjectException {
        this.visit((Event)boundaryEvent);
    }

    @Override
    public void visit(Gateway gateway) throws ProjectException {
        PersistenceFlowNodeHandler persistenceFlowNodeHandler = new PersistenceFlowNodeHandler(this.currentElementList);
        ModelUtils.handleFlowNodeChecked(gateway, persistenceFlowNodeHandler);
        TGateway tGateway = persistenceFlowNodeHandler.getGatewayRef();
        if (tGateway != null) {
            this.fillGatewayAttributes(tGateway, gateway);
            this.fillOracleExtensions(tGateway, gateway);
        }
    }

    @Override
    public void visit(SequenceFlow sequenceFlow) throws ProjectException {
        TSequenceFlow tSequenceflow = this.objectFactory.createTSequenceFlow();
        this.fillSequenceFlowAttributes(tSequenceflow, sequenceFlow);
        if (sequenceFlow.isConditionalFlow()) {
            Expression expression = sequenceFlow.toConditionalFlow().getCondition();
            tSequenceflow.setConditionExpression(this.createExtendedTFormalExpression(expression));
        }
        this.fillOracleExtensions(tSequenceflow, sequenceFlow);
        this.currentElementList.add(this.objectFactory.createSequenceFlow(tSequenceflow));
    }

    @Override
    public void visitFeature(Feature feature) throws ProjectException {
        block3: {
            block2: {
                Object value;
                block6: {
                    block5: {
                        block4: {
                            if (feature.isSet()) break block2;
                            if (!(feature instanceof PersistentFeature) || !((PersistentFeature)feature).mustBeSaved()) break block3;
                            value = feature.getValue();
                            if (!(value instanceof Expression)) break block4;
                            this.addExpressionExtension(feature.getName(), (Expression)value);
                            break block3;
                        }
                        if (!(value instanceof Integer)) break block5;
                        this.addIntegerExtension(feature.getName(), ((Integer)value).longValue());
                        break block3;
                    }
                    if (!(value instanceof Boolean)) break block6;
                    this.addBooleanExtension(feature.getName(), (Boolean)value);
                    break block3;
                }
                if (value == null) break block3;
                this.addStringExtension(feature.getName(), value.toString());
                break block3;
            }
            FeatureSet set = (FeatureSet)feature;
            if (set.mustBeSaved()) {
                for (Feature f : set.getFeatures()) {
                    if (!(f instanceof PersistentFeature)) continue;
                    f.visit(this);
                }
            }
        }
    }

    private static TActivity createWrapperTActivityFor(FlowNode source) {
        TActivity tActivity = new TActivity();
        tActivity.setId(source.getId());
        return tActivity;
    }

    private void visitFlowElements(NodeContainer nodeContainer) throws ProjectException {
        this.visitActivities(nodeContainer);
        this.visitEvents(nodeContainer);
        this.visitBoundaryEvents(nodeContainer);
        this.visitGateways(nodeContainer);
        this.visitSequenceFlows(nodeContainer);
        this.visitDataObjects(nodeContainer);
    }

    private void visitArtifacts(NodeContainer nodeContainer) throws ProjectException {
        this.visitMeasurementMarks(nodeContainer);
        this.visitCounters(nodeContainer);
        this.visitTextAnnotations(nodeContainer);
    }

    private void visitTextAnnotations(NodeContainer nodeContainer) throws ProjectException {
        for (TextAnnotation textAnnotation : nodeContainer.getTextAnnotations()) {
            TTextAnnotation tTextAnnotation = this.objectFactory.createTTextAnnotation();
            TText tText = this.objectFactory.createTText();
            tText.getContent().add(textAnnotation.getDefaultLabel());
            tTextAnnotation.setText(tText);
            this.fillOracleExtensions(tTextAnnotation, textAnnotation);
            this.currentArtifactList.add(tTextAnnotation);
        }
    }

    private void visitMeasurementMarks(NodeContainer nodeContainer) throws ProjectException {
        for (Measurement measurement : nodeContainer.getMeasurements()) {
            TMeasurementMark tMeasurementMark = this.objectFactory.createTMeasurementMark();
            tMeasurementMark.setId(measurement.getId());
            this.fillOracleExtensions(tMeasurementMark, measurement);
            if (measurement.getMeasurementType() != MeasurementType.STOP) {
                this.fillBusinessIndicators(tMeasurementMark.getAny(), measurement.getBusinessIndicators());
            }
            this.currentArtifactList.add(tMeasurementMark);
        }
    }

    private void fillBusinessIndicators(List<Object> list, Sequence<ProjectDataObject> businessIndicators) {
        TBusinessIndicators tBusinessIndicators = this.objectFactory.createTBusinessIndicators();
        for (ProjectDataObject businessIndicator : businessIndicators) {
            TBusinessIndicator tBusinessIndicator = this.objectFactory.createTBusinessIndicator();
            tBusinessIndicator.setId(businessIndicator.getId());
            tBusinessIndicators.getBusinessIndicator().add(tBusinessIndicator);
        }
        list.add(this.objectFactory.createBusinessIndicators(tBusinessIndicators));
    }

    private void visitCounters(NodeContainer nodeContainer) throws ProjectException {
        for (Counter counter : nodeContainer.getCounters()) {
            TCounter tCounter = this.objectFactory.createTCounter();
            tCounter.setId(counter.getId());
            this.fillOracleExtensions(tCounter, counter);
            this.fillBusinessIndicators(tCounter.getAny(), counter.getBusinessIndicators());
            this.currentArtifactList.add(tCounter);
        }
    }

    private void visitDataObjects(DataElementScope dataElementScope) {
        Sequence<DataObject> dataObjects = dataElementScope.getDataObjects();
        for (DataObject dataObject : dataObjects) {
            TDataObject tDataObject = this.createTDataObject(dataObject);
            this.currentElementList.add(this.objectFactory.createDataObject(tDataObject));
        }
    }

    private TDataObject createTDataObject(DataObject dataObject) {
        ProjectDataObject projectDataObject;
        TDataObject tDataObject = this.objectFactory.createTDataObject();
        tDataObject.setId(dataObject.getId());
        tDataObject.setName(dataObject.getId());
        TOracleExtensions extensions = this.getOracleExtensionsFor(tDataObject);
        TDataObjectType dataObjectType = this.extensionsFactory.createTDataObjectType();
        CatalogType type = dataObject.getType();
        dataObjectType.setTypeRef(this.createTTypeRef(type));
        dataObjectType.setInitialize(dataObject.isInitialize());
        if (dataObject instanceof ProjectDataObject && (projectDataObject = (ProjectDataObject)dataObject).isBusiness()) {
            TBusinessAttributes tBussinesAttributes = this.extensionsFactory.createTBusinessAttributes();
            BusinessVariableType businessVariableType = projectDataObject.getBusinessVariableType();
            tBussinesAttributes.setType(businessVariableType.name());
            BusinessVariableData variableData = projectDataObject.getBusinessVariableData();
            if (variableData != null && !variableData.isEmpty()) {
                BusinessVariableData.Range[] ranges;
                List<TBusinessDataRange> tBusinessDataRangeList = tBussinesAttributes.getBusinessDataRange();
                for (BusinessVariableData.Range range : ranges = variableData.getRange()) {
                    TBusinessDataRange tBusinessDataRange = this.extensionsFactory.createTBusinessDataRange();
                    tBusinessDataRange.setName(range.getName());
                    tBusinessDataRange.setStart(range.getStart());
                    tBusinessDataRange.setFinish(range.getFinish());
                    tBusinessDataRangeList.add(tBusinessDataRange);
                }
            }
            dataObjectType.setBusinessAttributes(tBussinesAttributes);
        }
        extensions.setDataObjectType(dataObjectType);
        return tDataObject;
    }

    private TTypeRef createTTypeRef(@NotNull CatalogType catalogType) {
        TypeDescription type;
        TypeDescription td = catalogType.getDelegate();
        boolean isArray = catalogType.isArray();
        TTypeRef tTypeRef = new TTypeRef();
        TypeDescription typeDescription = type = isArray ? td.getElementType() : td;
        if (!type.isUnknown() && type.getErrors().isEmpty()) {
            if (type.isSchemaObject()) {
                SchemaObject schemaObject = type.asSchemaObject();
                tTypeRef.setNamespace(schemaObject.getNamespace());
                switch (schemaObject.getXmlElementType()) {
                    case TYPE: {
                        tTypeRef.setType(schemaObject.getName());
                        break;
                    }
                    case ELEMENT: {
                        tTypeRef.setElement(schemaObject.getName());
                        break;
                    }
                    case FAULT: {
                        tTypeRef.setFault(schemaObject.getName());
                        assert (catalogType instanceof FaultObject);
                        FaultObject errorObject = (FaultObject)catalogType;
                        QName message = errorObject.getMessageQName();
                        if (message == null) break;
                        tTypeRef.setMessageNamespace(message.getNamespaceURI());
                        tTypeRef.setMessage(message.getLocalPart());
                    }
                }
            } else if (catalogType instanceof SystemFaultObject) {
                SystemFaultObject fault = (SystemFaultObject)catalogType;
                QName errorCode = fault.getErrorCode();
                tTypeRef.setNamespace(errorCode.getNamespaceURI());
                tTypeRef.setType(errorCode.getLocalPart());
            }
        } else {
            tTypeRef.setNamespace(type.get().getName());
        }
        tTypeRef.setIsArray(isArray);
        return tTypeRef;
    }

    private void fillActivityIoSpecification(TActivity tActivity, Activity activity) throws ProjectException {
        if (this.hasIoSpecification(activity)) {
            OutputArgumentsEnabled outputArgumentEnabled;
            InputArgumentsEnabled inputArgumentEnabled;
            TInputOutputSpecification tInputOutputSpecification = this.objectFactory.createTInputOutputSpecification();
            IncomingDataAssociationFeature incomingDataAssociationFeature = activity.getFeature(IncomingDataAssociationFeature.class);
            OutgoingDataAssociationFeature outgoingDataAssociationFeature = activity.getFeature(OutgoingDataAssociationFeature.class);
            InputArgumentsEnabled inputArgumentsEnabled = inputArgumentEnabled = InputArgumentsEnabled.class.isAssignableFrom(activity.getRawClass()) ? (InputArgumentsEnabled)((Object)activity) : null;
            if (inputArgumentEnabled != null) {
                this.createDataInputs(activity, inputArgumentEnabled.getInputArgumentsContainer().getDeclarations(), tInputOutputSpecification.getDataInput(), tInputOutputSpecification.getInputSet(), null);
            }
            this.createInputDataAssociations(activity, incomingDataAssociationFeature, tActivity);
            OutputArgumentsEnabled outputArgumentsEnabled = outputArgumentEnabled = OutputArgumentsEnabled.class.isAssignableFrom(activity.getRawClass()) ? (OutputArgumentsEnabled)((Object)activity) : null;
            if (outputArgumentEnabled != null) {
                this.createDataOutputs(activity, outputArgumentEnabled.getOutputArgumentsContainer().getDeclarations(), tInputOutputSpecification.getDataOutput(), tInputOutputSpecification.getOutputSet(), null);
            }
            this.createOutDataAssociations(activity, outgoingDataAssociationFeature, tActivity);
            tActivity.setIoSpecification(tInputOutputSpecification);
        }
    }

    private void fillProcessIoSpecification(Process process) throws ProjectException {
        if (process.isCallableSubprocess()) {
            TInputOutputSpecification tInputOutputSpecification = this.objectFactory.createTInputOutputSpecification();
            DataDeclarationContainer inputContainer = process.getInputArgumentsContainer();
            this.createDataInputs(process, inputContainer.getDeclarations(), tInputOutputSpecification.getDataInput(), tInputOutputSpecification.getInputSet(), null);
            DataDeclarationContainer outputContainer = process.getOutputArgumentsContainer();
            this.createDataOutputs(process, outputContainer.getDeclarations(), tInputOutputSpecification.getDataOutput(), tInputOutputSpecification.getOutputSet(), null);
            this.tProcess.setIoSpecification(tInputOutputSpecification);
        }
    }

    private void fillEventTrigger(TEvent tEvent, Event event) throws ProjectException {
        if (event.getEventDefinition() != null || event.getEventTriggerType() == EventTriggerType.NONE) {
            ModelUtils.handleEventTriggerChecked(event, new PersistenceEventDefinitionHandler(tEvent));
        }
    }

    private boolean hasIoSpecification(FlowElement flowElement) {
        return this.hasInputDataAssociation(flowElement) || this.hasOutputDataAssociation(flowElement) || flowElement.getFeature(InOutDataAssociationFeature.class) != null;
    }

    private boolean hasOutputDataAssociation(FlowElement flowElement) {
        return flowElement.getFeature(OutgoingDataAssociationFeature.class) != null;
    }

    private boolean hasInputDataAssociation(FlowElement flowElement) {
        return flowElement.getFeature(IncomingDataAssociationFeature.class) != null;
    }

    private void createInputDataAssociations(ProjectObject projectObject, IncomingDataAssociationFeature incomingDataAssociationFeature, TBaseElement tBaseElement) throws ProjectException {
        if (incomingDataAssociationFeature != null) {
            TDataInputAssociation tDataInputAssociation;
            List<TDataInputAssociation> tDataInputAssociations;
            if (tBaseElement instanceof TActivity) {
                tDataInputAssociations = ((TActivity)tBaseElement).getDataInputAssociation();
            } else if (tBaseElement instanceof TThrowEvent) {
                tDataInputAssociations = ((TThrowEvent)tBaseElement).getDataInputAssociation();
            } else {
                throw new ProjectException(projectObject, CoreMsg.ERROR_MSG("invalid type with no dataInputAssociations"));
            }
            Sequence<DataAssociation> inDataAssociations = incomingDataAssociationFeature.getDataAssociationSet().getDataAssociations();
            for (DataAssociation dataAssociation : inDataAssociations) {
                DataAssociationItem targetItem = dataAssociation.getTarget();
                String targetRefString = !targetItem.getRefs().isEmpty() ? targetItem.getRefs().iterator().next() : "";
                tDataInputAssociation = null;
                for (TDataInputAssociation tDataAssociation : tDataInputAssociations) {
                    if (!tDataAssociation.getTargetRef().equals(targetRefString)) continue;
                    tDataInputAssociation = tDataAssociation;
                    break;
                }
                if (tDataInputAssociation == null) {
                    tDataInputAssociation = this.objectFactory.createTDataInputAssociation();
                    tDataInputAssociation.setTargetRef(targetRefString);
                    tDataInputAssociations.add(tDataInputAssociation);
                }
                this.setTDataAssociationValues(tDataInputAssociation, dataAssociation, incomingDataAssociationFeature.getDataAssociationSet().getExpressionMode());
            }
            Sequence<DataTransformation> inDataTransformations = incomingDataAssociationFeature.getDataAssociationSet().getDataTransformations();
            for (DataTransformation dataTransformation : inDataTransformations) {
                String targetRef = dataTransformation.getTargetRef();
                tDataInputAssociation = this.objectFactory.createTDataInputAssociation();
                tDataInputAssociation.setTargetRef(targetRef);
                tDataInputAssociations.add(tDataInputAssociation);
                this.setTDataAssociationValues(tDataInputAssociation, dataTransformation);
            }
        }
    }

    private void createDataInputs(ProjectObject projectObject, Sequence<DataDeclaration> inputArguments, List<TDataInput> tDataInputs, List<TInputSet> tInputSets, TInputSet tInputSet) {
        if (inputArguments != null && !inputArguments.isEmpty()) {
            List<JAXBElement<Object>> inputRefs;
            String id = projectObject.getId() + "_uniqueInputSet";
            if (tInputSet == null) {
                TInputSet uniqueInputSet = this.objectFactory.createTInputSet();
                inputRefs = uniqueInputSet.getDataInputRefs();
                uniqueInputSet.setId(id);
                tInputSets.add(uniqueInputSet);
            } else {
                inputRefs = tInputSet.getDataInputRefs();
                tInputSet.setId(id);
            }
            for (DataDeclaration inputArgument : inputArguments) {
                TDataInput tDataInput = this.objectFactory.createTDataInput();
                tDataInput.setId(inputArgument.getName());
                tDataInput.setName(inputArgument.getName());
                TOracleExtensions extensions = this.getOracleExtensionsFor(tDataInput);
                extensions.setTypeRef(this.createTTypeRef(inputArgument.getType()));
                tDataInputs.add(tDataInput);
                JAXBElement objectJAXBElement = new JAXBElement(new QName(BPMN_NS, "dataInput"), Object.class, null, (Object)tDataInput);
                inputRefs.add((JAXBElement<Object>)objectJAXBElement);
            }
        }
    }

    private void setTDataAssociationValues(TDataAssociation tDataAssociation, DataAssociation dataAssociation, @NotNull ExpressionMode expressionMode) {
        DataAssociationItem sourceItem = dataAssociation.getSource();
        DataAssociationItem targetItem = dataAssociation.getTarget();
        TOracleExtensions tOracleExtensions = this.getOracleExtensionsFor(tDataAssociation);
        List<String> otherRefs = tOracleExtensions.getOtherRef();
        for (DataAssociationItemRef ref : sourceItem.getDataAssociationItemRefs()) {
            if (!ref.isOtherRef()) {
                if (tDataAssociation.getSourceRef().contains(ref.getRef())) continue;
                tDataAssociation.getSourceRef().add(ref.getRef());
                continue;
            }
            if (otherRefs.contains(ref.getRef())) continue;
            otherRefs.add(ref.getRef());
        }
        for (DataAssociationItemRef ref : targetItem.getDataAssociationItemRefs()) {
            if (!ref.isOtherRef() || otherRefs.contains(ref.getRef())) continue;
            otherRefs.add(ref.getRef());
        }
        TAssignment tAssignment = this.createTAssignment(sourceItem, targetItem, expressionMode, dataAssociation.isCustom());
        tDataAssociation.getAssignment().add(tAssignment);
    }

    private void setTDataAssociationValues(TDataAssociation tDataAssociation, DataTransformation dataTransformation) {
        Sequence<String> sourceRefs = dataTransformation.getSourceRefs();
        for (String sourceRef : sourceRefs) {
            if (tDataAssociation.getSourceRef().contains(sourceRef)) continue;
            tDataAssociation.getSourceRef().add(sourceRef);
        }
        TFormalExpression transformation = this.createTransformation(dataTransformation.getTransformationName());
        tDataAssociation.setTransformation(transformation);
    }

    private TAssignment createTAssignment(@NotNull DataAssociationItem sourceItem, @NotNull DataAssociationItem targetItem, @NotNull ExpressionMode expressionMode, boolean isCustom) {
        TAssignment tAssignment = this.objectFactory.createTAssignment();
        tAssignment.setLanguage(ExpressionLanguage.XPATH.getId());
        Expression sourceExpression = sourceItem.getExpression();
        Expression targetExpression = targetItem.getExpression();
        TFormalExpression tFrom = this.createTFormalExpression(sourceExpression);
        tAssignment.setFrom(tFrom);
        TFormalExpression tTo = this.createTFormalExpression(targetExpression);
        tAssignment.setTo(tTo);
        TOracleExtensions tOracleExtensions = this.getOracleExtensionsFor(tAssignment);
        TDataAssignment tDataAssignment = this.extensionsFactory.createTDataAssignment();
        tDataAssignment.setIsCustom(isCustom);
        tDataAssignment.setMode(expressionMode.getId());
        tOracleExtensions.setDataAssignment(tDataAssignment);
        return tAssignment;
    }

    private TAttributeExpression createTAttributeExpression(String attName, Expression expression) {
        TAttributeExpression attributeExpression = this.objectFactory.createTAttributeExpression();
        attributeExpression.setAttributeName(attName);
        this.fillFormalExpression(attributeExpression, expression);
        return attributeExpression;
    }

    private TFormalExpression createTFormalExpression(Expression expression) {
        TFormalExpression tFormalExpression = this.objectFactory.createTFormalExpression();
        this.fillFormalExpression(tFormalExpression, expression);
        return tFormalExpression;
    }

    private void fillFormalExpression(TFormalExpression tFormalExpression, Expression expression) {
        if (expression != null) {
            tFormalExpression.getContent().add(expression.getExpressionValue());
            tFormalExpression.setLanguage(expression.getLanguage().getId());
            Map namespaces = expression.getNamespaces();
            Map<QName, String> otherAtts = tFormalExpression.getOtherAttributes();
            for (String key : namespaces.keySet()) {
                URI uri = (URI)namespaces.get(key);
                otherAtts.put(this.createQNameFor("xmlns:" + key, null), uri.toString());
            }
        }
    }

    private TFormalExpression createExtendedTFormalExpression(Expression expression) {
        TFormalExpression tFormalExpression = this.createTFormalExpression(expression);
        if (expression != null) {
            TOracleExtensions tOracleExtensions = this.getOracleExtensionsFor(tFormalExpression);
            TExpression tExpressionExtension = this.extensionsFactory.createTExpression();
            tExpressionExtension.setMode(expression.getMode().getId());
            tOracleExtensions.setExpression(tExpressionExtension);
        }
        return tFormalExpression;
    }

    private TFormalExpression createTransformation(@NotNull String transformationName) {
        TFormalExpression transformation = this.objectFactory.createTFormalExpression();
        transformation.setLanguage("xsl");
        TOracleExtensions tOracleExtensions = this.getOracleExtensionsFor(transformation);
        TExternalTransformation tExternalTransformation = this.extensionsFactory.createTExternalTransformation();
        String transformationFileName = transformationName + ".xsl";
        tExternalTransformation.setResource(transformationFileName);
        tOracleExtensions.setExternalTransformation(tExternalTransformation);
        return transformation;
    }

    private void createOutDataAssociations(ProjectObject flowNode, OutgoingDataAssociationFeature outgoingDataAssociationFeature, TBaseElement tBaseElement) throws ProjectException {
        if (outgoingDataAssociationFeature != null) {
            TDataOutputAssociation tDataOutputAssociation;
            List<TDataOutputAssociation> tDataOutputAssociations;
            if (tBaseElement instanceof TActivity) {
                tDataOutputAssociations = ((TActivity)tBaseElement).getDataOutputAssociation();
            } else if (tBaseElement instanceof TCatchEvent) {
                tDataOutputAssociations = ((TCatchEvent)tBaseElement).getDataOutputAssociation();
            } else {
                throw new ProjectException(flowNode, CoreMsg.ERROR_MSG("invalid type with no dataOutputAssociations"));
            }
            Sequence<DataAssociation> outDataAssociations = outgoingDataAssociationFeature.getDataAssociationSet().getDataAssociations();
            for (DataAssociation dataAssociation : outDataAssociations) {
                DataAssociationItem targetItem = dataAssociation.getTarget();
                String targetRefString = !targetItem.getRefs().isEmpty() ? targetItem.getRefs().iterator().next() : "";
                tDataOutputAssociation = null;
                for (TDataOutputAssociation tDataAssociation : tDataOutputAssociations) {
                    if (!tDataAssociation.getTargetRef().equals(targetRefString)) continue;
                    tDataOutputAssociation = tDataAssociation;
                    break;
                }
                if (tDataOutputAssociation == null) {
                    tDataOutputAssociation = this.objectFactory.createTDataOutputAssociation();
                    tDataOutputAssociation.setTargetRef(targetRefString);
                    tDataOutputAssociations.add(tDataOutputAssociation);
                }
                this.setTDataAssociationValues(tDataOutputAssociation, dataAssociation, outgoingDataAssociationFeature.getDataAssociationSet().getExpressionMode());
            }
            Sequence<DataTransformation> outDataTransformations = outgoingDataAssociationFeature.getDataAssociationSet().getDataTransformations();
            for (DataTransformation dataTransformation : outDataTransformations) {
                String targetRef = dataTransformation.getTargetRef();
                tDataOutputAssociation = this.objectFactory.createTDataOutputAssociation();
                tDataOutputAssociation.setTargetRef(targetRef);
                tDataOutputAssociations.add(tDataOutputAssociation);
                this.setTDataAssociationValues(tDataOutputAssociation, dataTransformation);
            }
        }
    }

    private void createDataOutputs(ProjectObject projectObject, Sequence<DataDeclaration> outputArguments, List<TDataOutput> tDataOutputs, List<TOutputSet> tOutputSets, TOutputSet tOutputSet) {
        if (outputArguments != null && !outputArguments.isEmpty()) {
            List<JAXBElement<Object>> outputRefs;
            String id = projectObject.getId() + "_uniqueOutputSet";
            if (tOutputSet == null) {
                TOutputSet uniqueOutputSet = this.objectFactory.createTOutputSet();
                outputRefs = uniqueOutputSet.getDataOutputRefs();
                uniqueOutputSet.setId(id);
                tOutputSets.add(uniqueOutputSet);
            } else {
                outputRefs = tOutputSet.getDataOutputRefs();
                tOutputSet.setId(id);
            }
            for (DataDeclaration outputArgument : outputArguments) {
                TDataOutput tDataOutput = this.objectFactory.createTDataOutput();
                tDataOutput.setId(outputArgument.getName());
                tDataOutput.setName(outputArgument.getName());
                TOracleExtensions extensions = this.getOracleExtensionsFor(tDataOutput);
                extensions.setTypeRef(this.createTTypeRef(outputArgument.getType()));
                tDataOutputs.add(tDataOutput);
                JAXBElement objectJAXBElement = new JAXBElement(new QName(BPMN_NS, "dataOutput"), Object.class, null, (Object)tDataOutput);
                outputRefs.add((JAXBElement<Object>)objectJAXBElement);
            }
        }
    }

    private void addRolesDefinitions(Process process) {
        for (Lane lane : process.getLanes()) {
            TPeopleGroup peopleGroup = new TPeopleGroup();
            peopleGroup.setName(lane.getName());
            peopleGroup.setId(lane.getId());
            this.fillOracleExtensions(peopleGroup, lane);
            this.definitions.getRootElement().add(this.objectFactory.createPeopleGroup(peopleGroup));
        }
    }

    private void fillOracleExtensions(TPeopleGroup tPeopleGroup, Lane lane) {
        TOracleExtensions tOracleExtensions = this.getOracleExtensionsFor(tPeopleGroup);
        TGraphicsAttributes tGraphicsAttributes = this.generateNodesGraphicalExtension(lane);
        tOracleExtensions.setGraphicsAttributes(tGraphicsAttributes);
    }

    private TOracleExtensions getOracleExtensionsFor(TBaseElement element) {
        TOracleExtensions extensions = this.findOracleExtensionsIn(element);
        if (extensions == null) {
            extensions = this.extensionsFactory.createTOracleExtensions();
            element.getAny().add(this.extensionsFactory.createOracleExtensions(extensions));
        }
        return extensions;
    }

    private TOracleExtensions getOracleExtensionsFor(TBaseElementWithMixedContent element) {
        TOracleExtensions extensions = this.findOracleExtensionsIn(element);
        if (extensions == null) {
            extensions = this.extensionsFactory.createTOracleExtensions();
            element.getContent().add(this.extensionsFactory.createOracleExtensions(extensions));
        }
        return extensions;
    }

    private TOracleExtensions findOracleExtensionsIn(TBaseElement element) {
        List<Object> extensions = element.getAny();
        return this.getEmptyOracleExtensions(extensions);
    }

    private TLocalization createLocalizationFor(Localizable localizable) {
        TLocalization tLocalization = this.extensionsFactory.createTLocalization();
        this.addLocalizationIn(tLocalization, localizable.getLabelMap(), localizable.getDescriptionMap(), localizable.getDocumentationMap(), localizable.getUseCaseDocumentationMap());
        return tLocalization;
    }

    private void addLocalizationIn(TLocalization tLocalization, LocaleStringMap labelMap, LocaleStringMap descriptionMap, LocaleStringMap documentationMap, LocaleStringMap useCaseDocumentationMap) {
        Set<Map.Entry<Locale, String>> entries;
        if (labelMap != null && !(entries = labelMap.entrySet()).isEmpty()) {
            tLocalization.setLabel(this.extensionsFactory.createTLabel());
            this.addLocalizationItems(entries, tLocalization.getLabel());
        }
        if (descriptionMap != null && !(entries = descriptionMap.entrySet()).isEmpty()) {
            tLocalization.setDescription(this.extensionsFactory.createTDescription());
            this.addLocalizationItems(entries, tLocalization.getDescription());
        }
        if (documentationMap != null && !(entries = documentationMap.entrySet()).isEmpty()) {
            tLocalization.setDocumentation(this.extensionsFactory.createTDocumentation());
            this.addLocalizationItems(entries, tLocalization.getDocumentation());
        }
        if (useCaseDocumentationMap != null && !(entries = useCaseDocumentationMap.entrySet()).isEmpty()) {
            tLocalization.setUseCaseDocumentation(this.extensionsFactory.createTUseCaseDocumentation());
            this.addLocalizationItems(entries, tLocalization.getUseCaseDocumentation());
        }
    }

    private void addLocalizationItems(Set<Map.Entry<Locale, String>> entries, TLocalizedItemsContainer tLocalizedItemsContainer) {
        for (Map.Entry<Locale, String> entry : entries) {
            tLocalizedItemsContainer.getLocalizedContent().add(this.createLocalizedContent(entry.getKey(), entry.getValue()));
        }
    }

    private TLocalizedContent createLocalizedContent(Locale locale, String contentValue) {
        TLocalizedContent tLocalizedContent = this.extensionsFactory.createTLocalizedContent();
        tLocalizedContent.setLanguage(locale.toString());
        tLocalizedContent.setContent(contentValue);
        return tLocalizedContent;
    }

    private TOracleExtensions getEmptyOracleExtensions(List<Object> extensions) {
        TOracleExtensions tOracleExtensions = null;
        for (Object extension : extensions) {
            Object value;
            if (!(extension instanceof JAXBElement) || !((value = ((JAXBElement)extension).getValue()) instanceof TOracleExtensions)) continue;
            tOracleExtensions = (TOracleExtensions)value;
            break;
        }
        return tOracleExtensions;
    }

    private TOracleExtensions findOracleExtensionsIn(TBaseElementWithMixedContent element) {
        List<Object> extensions = element.getContent();
        return this.getEmptyOracleExtensions(extensions);
    }

    private void createPerformer(TActivity tActivity, Activity activity) {
        Lane lane = activity.getLane();
        if (lane != null) {
            TPerformer performer = new TPerformer();
            performer.setId(lane.getId());
            performer.setName(lane.getName());
            tActivity.getPerformer().add(this.objectFactory.createPerformer(performer));
        }
    }

    private void fillOracleExtensions(TFlowElement tFlowElement, FlowNode flowNode) throws ProjectException {
        TOracleExtensions extensions = this.getOracleExtensionsFor(tFlowElement);
        extensions.setGraphicsAttributes(this.generateNodesGraphicalExtension(flowNode));
        Boolean shouldPersistI18N = flowNode.getProcess().getFeature(IncludesStoredI18n.class).getValue();
        if (shouldPersistI18N.booleanValue()) {
            extensions.setLocalization(this.createLocalizationFor(flowNode));
        }
        extensions.setFeatureSet(this.generateFeaturesExtensions(flowNode.getFeatures()));
    }

    private void fillOracleExtensions(TArtifact tArtifact, Artifact artifact) throws ProjectException {
        TOracleExtensions extensions = this.getOracleExtensionsFor(tArtifact);
        TGraphicsAttributes graphicAttributes = this.generateNodesGraphicalExtension(artifact);
        extensions.setGraphicsAttributes(graphicAttributes);
        TLocalization localization = this.createLocalizationFor(artifact);
        extensions.setLocalization(localization);
        TFeatureSet tFeatureSet = this.generateFeaturesExtensions(artifact.getFeatures());
        extensions.setFeatureSet(tFeatureSet);
    }

    private TFeatureSet generateFeaturesExtensions(Features features) throws ProjectException {
        this.currentFeatureSet = this.extensionsFactory.createTFeatureSet();
        for (Feature feature : features) {
            if (feature instanceof AnnotationsFeature) {
                this.generateAllAnnotations((AnnotationsFeature)feature);
                continue;
            }
            feature.visit(this);
        }
        return this.currentFeatureSet;
    }

    private void generateAllAnnotations(AnnotationsFeature annotationsFeature) throws ProjectException {
        if (annotationsFeature.hasAnnotations()) {
            AnnotationsFeature.HiddenAnnotationsFeature hiddenAnnotationsFeature;
            TFeatureSet oldFeatureSet = this.currentFeatureSet;
            TAnnotations tAnnotations = this.extensionsFactory.createTAnnotations();
            this.currentFeatureSet = tAnnotations;
            AnnotationsFeature.UserAnnotationsFeature userAnnotationsFeature = annotationsFeature.getFeature(AnnotationsFeature.UserAnnotationsFeature.class);
            if (userAnnotationsFeature.hasAnnotations()) {
                tAnnotations.setUserAnnotations(this.generateUserAnnotations(userAnnotationsFeature));
            }
            if ((hiddenAnnotationsFeature = annotationsFeature.getFeature(AnnotationsFeature.HiddenAnnotationsFeature.class)).hasAnnotations()) {
                tAnnotations.setHiddenAnnotations(this.generateHiddenAnnotations(hiddenAnnotationsFeature));
            }
            this.currentFeatureSet = oldFeatureSet;
            this.currentFeatureSet.setAnnotations(tAnnotations);
        }
    }

    private TUserAnnotations generateUserAnnotations(AnnotationsFeature.UserAnnotationsFeature mapFeature) throws ProjectException {
        TFeatureSet oldFeatureSet = this.currentFeatureSet;
        TUserAnnotations tUserAnnotations = this.extensionsFactory.createTUserAnnotations();
        this.currentFeatureSet = tUserAnnotations;
        for (Feature annotation : mapFeature.getFeatures()) {
            annotation.visit(this);
        }
        this.currentFeatureSet = oldFeatureSet;
        return tUserAnnotations;
    }

    private THiddenAnnotations generateHiddenAnnotations(AnnotationsFeature.HiddenAnnotationsFeature mapFeature) throws ProjectException {
        TFeatureSet oldFeatureSet = this.currentFeatureSet;
        THiddenAnnotations tUserAnnotations = this.extensionsFactory.createTHiddenAnnotations();
        this.currentFeatureSet = tUserAnnotations;
        for (Feature annotation : mapFeature.getFeatures()) {
            annotation.visit(this);
        }
        this.currentFeatureSet = oldFeatureSet;
        return tUserAnnotations;
    }

    private void fillOracleExtensions(TSequenceFlow tSequenceFlow, SequenceFlow sequenceFlow) throws ProjectException {
        TOracleExtensions extensions = this.getOracleExtensionsFor(tSequenceFlow);
        TSequenceFlowAttributes sequenceFlowAttributes = this.generateSequenceFlowAttributes(sequenceFlow);
        extensions.setSequenceFlowAttributes(sequenceFlowAttributes);
        TFeatureSet tFeatureSet = this.generateFeaturesExtensions(sequenceFlow.getFeatures());
        extensions.setFeatureSet(tFeatureSet);
    }

    private TSequenceFlowAttributes generateSequenceFlowAttributes(SequenceFlow sequenceFlow) {
        TSequenceFlowAttributes sequenceFlowAttributes = this.extensionsFactory.createTSequenceFlowAttributes();
        if (sequenceFlow.isCurve()) {
            TPosition position = this.extensionsFactory.createTPosition();
            position.setX(sequenceFlow.getControlPoint().getX());
            position.setY(sequenceFlow.getControlPoint().getY());
            sequenceFlowAttributes.getPositions().add(position);
        }
        return sequenceFlowAttributes;
    }

    private TGraphicsAttributes generateNodesGraphicalExtension(Lane lane) {
        TGraphicsAttributes graphicAttributes = this.extensionsFactory.createTGraphicsAttributes();
        TPosition position = this.extensionsFactory.createTPosition();
        position.setX(lane.getOffset());
        TSize size = this.extensionsFactory.createTSize();
        size.setWidth(lane.getSize());
        graphicAttributes.setPosition(position);
        graphicAttributes.setSize(size);
        return graphicAttributes;
    }

    private TGraphicsAttributes generateNodesGraphicalExtension(Positional positional) {
        TGraphicsAttributes graphicAttributes = this.extensionsFactory.createTGraphicsAttributes();
        TPosition position = this.extensionsFactory.createTPosition();
        TSize size = this.extensionsFactory.createTSize();
        position.setX(positional.getX());
        position.setY(positional.getY());
        size.setHeight(positional.getHeight());
        size.setWidth(positional.getWidth());
        graphicAttributes.setSize(size);
        graphicAttributes.setPosition(position);
        return graphicAttributes;
    }

    private QName createQNameFor(String str) {
        return this.createQNameFor(str, BPMN_NS);
    }

    private QName createQNameFor(String str, String namespace) {
        return QName.valueOf(str == null ? "" : (namespace == null || namespace.equals("") ? str : "{" + namespace + "}" + str));
    }

    private void visitEvents(NodeContainer nodeContainer) throws ProjectException {
        for (Event event : nodeContainer.getEvents()) {
            event.visit(this);
        }
    }

    private void visitBoundaryEvents(NodeContainer nodeContainer) throws ProjectException {
        for (BoundaryEvent boundaryEvent : nodeContainer.getBoundaryEvents()) {
            boundaryEvent.visit(this);
        }
    }

    private void visitActivities(NodeContainer nodeContainer) throws ProjectException {
        for (Activity activity : nodeContainer.getActivities()) {
            activity.visit(this);
        }
    }

    private void visitGateways(NodeContainer nodeContainer) throws ProjectException {
        for (Gateway gateway : nodeContainer.getGateways()) {
            gateway.visit(this);
        }
    }

    private void visitSequenceFlows(NodeContainer nodeContainer) throws ProjectException {
        for (SequenceFlow sequenceFlow : nodeContainer.getSequenceFlows()) {
            sequenceFlow.visit(this);
        }
    }

    private void fillSequenceFlowAttributes(TSequenceFlow tSequenceflow, SequenceFlow sequenceFlow) {
        tSequenceflow.setId(sequenceFlow.getId());
        tSequenceflow.setName(sequenceFlow.getId());
        tSequenceflow.setSourceRef(ProcessVisitor.createWrapperTActivityFor(sequenceFlow.getSource()));
        tSequenceflow.setTargetRef(ProcessVisitor.createWrapperTActivityFor(sequenceFlow.getTarget()));
    }

    private void fillGatewayAttributes(TGateway tGateway, Gateway gateway) {
        if (gateway != null && gateway.getId() != null) {
            tGateway.setId(gateway.getId());
            String defaultLabel = gateway.getDefaultLabel();
            if (!Str.isEmpty(defaultLabel)) {
                tGateway.setName(defaultLabel);
            }
            tGateway.setGatewayDirection(TGatewayDirection.fromValue(gateway.getDirection().name().toLowerCase()));
        }
    }

    private void fillEventAttributes(TEvent tEvent, Event event) {
        if (event != null && event.getId() != null) {
            tEvent.setId(event.getId());
            String defaultLabel = event.getDefaultLabel();
            if (!Str.isEmpty(defaultLabel)) {
                tEvent.setName(defaultLabel);
            }
        }
    }

    private void fillActivityAttributes(TActivity tActivity, Activity activity) {
        if (activity != null && activity.getId() != null) {
            tActivity.setId(activity.getId());
            String defaultLabel = activity.getDefaultLabel();
            if (!Str.isEmpty(defaultLabel)) {
                tActivity.setName(defaultLabel);
            }
        }
        tActivity.setIsForCompensation(false);
        this.fillActivityLoopCharacteristics(tActivity, activity);
    }

    private void fillActivityLoopCharacteristics(TActivity tActivity, Activity activity) {
        LoopCharacteristicsType loopType = activity.getLoopCharacteristicsType();
        if (loopType != null && loopType != LoopCharacteristicsType.NONE) {
            TLoopCharacteristics loopCharacteristics = null;
            switch (loopType) {
                case LOOP: {
                    TStandardLoopCharacteristics characteristics;
                    Loop loop = activity.getLoopCharacteristics().as(Loop.class);
                    loopCharacteristics = characteristics = this.objectFactory.createTStandardLoopCharacteristics();
                    characteristics.setTestBefore(loop.isTestBefore());
                    if (loop.hasLoopMaximum()) {
                        characteristics.setLoopMaximum(BigInteger.valueOf(loop.getLoopMaximum()));
                    }
                    characteristics.setLoopCondition(this.createExtendedTFormalExpression(loop.getLoopExpression()));
                    break;
                }
                case MULTIINSTANCE: {
                    MultiInstance multiInstance = activity.getLoopCharacteristics().as(MultiInstance.class);
                    TMultiInstanceLoopCharacteristics characteristics = this.objectFactory.createTMultiInstanceLoopCharacteristics();
                    loopCharacteristics = characteristics;
                    characteristics.setBehavior(TMultiInstanceFlowCondition.ALL);
                    characteristics.setIsSequential(multiInstance.isSequential());
                    characteristics.setLoopCardinality(this.createExtendedTFormalExpression(multiInstance.getLoopCardinality()));
                    characteristics.setCompletionCondition(this.createExtendedTFormalExpression(multiInstance.getCompletionCondition()));
                    TDataInput tDataInput = this.objectFactory.createTDataInput();
                    DataDeclaration inputDataDeclaration = multiInstance.getLoopDataInput();
                    if (inputDataDeclaration != null) {
                        tDataInput.setId(inputDataDeclaration.getName());
                        tDataInput.setName(inputDataDeclaration.getName());
                        TOracleExtensions extensions = this.getOracleExtensionsFor(tDataInput);
                        extensions.setTypeRef(this.createTTypeRef(inputDataDeclaration.getType()));
                        characteristics.setLoopDataInput(tDataInput);
                    }
                    TDataOutput tDataOutput = this.objectFactory.createTDataOutput();
                    DataDeclaration outputDataDeclaration = multiInstance.getLoopDataOutput();
                    if (outputDataDeclaration == null) break;
                    tDataOutput.setId(outputDataDeclaration.getName());
                    tDataOutput.setName(outputDataDeclaration.getName());
                    TOracleExtensions extensions = this.getOracleExtensionsFor(tDataOutput);
                    extensions.setTypeRef(this.createTTypeRef(outputDataDeclaration.getType()));
                    characteristics.setLoopDataOutput(tDataOutput);
                    break;
                }
            }
            tActivity.setLoopCharacteristics(this.objectFactory.createLoopCharacteristics(loopCharacteristics));
        }
    }

    private void fillOracleExtensions(Process process) throws ProjectException {
        TOracleExtensions tOracleExtensions = this.getOracleExtensionsFor(this.tProcess);
        TFeatureSet tFeatureSet = this.generateFeaturesExtensions(process.getFeatures());
        tOracleExtensions.setFeatureSet(tFeatureSet);
    }

    private void addStringExtension(String featureName, String value) {
        this.currentFeatureSet.getStringFeature().add(this.createStringFeature(featureName, value));
    }

    private TStringFeature createStringFeature(String featureName, String value) {
        TStringFeature stringFeature = this.extensionsFactory.createTStringFeature();
        stringFeature.setName(featureName);
        stringFeature.setValue(value);
        return stringFeature;
    }

    private void addBooleanExtension(String featureName, Boolean value) {
        this.currentFeatureSet.getBooleanFeature().add(this.createBooleanFeature(featureName, value));
    }

    private TBooleanFeature createBooleanFeature(String featureName, Boolean value) {
        TBooleanFeature booleanFeature = this.extensionsFactory.createTBooleanFeature();
        booleanFeature.setName(featureName);
        booleanFeature.setValue(value);
        return booleanFeature;
    }

    private void addIntegerExtension(String featureName, Long value) {
        this.currentFeatureSet.getIntegerFeature().add(this.createIntegerFeature(featureName, value));
    }

    private void addExpressionExtension(String featureName, Expression value) {
        this.currentFeatureSet.getAny().add(this.objectFactory.createAttributeExpression(this.createTAttributeExpression(featureName, value)));
    }

    private TIntegerFeature createIntegerFeature(String featureName, Long value) {
        TIntegerFeature tIntegerFeature = this.extensionsFactory.createTIntegerFeature();
        tIntegerFeature.setName(featureName);
        tIntegerFeature.setValue(BigInteger.valueOf(value));
        return tIntegerFeature;
    }

    private void fillSubprocessData(Subprocess subprocess, TSubProcess tSubProcess) throws ProjectException {
        List<JAXBElement<? extends TFlowElement>> oldElementList = this.currentElementList;
        List<TArtifact> oldArtifactList = this.currentArtifactList;
        this.currentElementList = tSubProcess.getFlowElement();
        this.currentArtifactList = tSubProcess.getArtifact();
        this.visitFlowElements(subprocess);
        this.visitArtifacts(subprocess);
        this.currentElementList = oldElementList;
        this.currentArtifactList = oldArtifactList;
    }

    private class PersistenceFlowNodeHandler
    extends CheckedFlowNodeAdapter {
        private final List<JAXBElement<? extends TFlowElement>> flowElements;
        private TActivity tActivityRef;
        private TEvent tEventRef;
        private TGateway tGatewayRef;

        PersistenceFlowNodeHandler(List<JAXBElement<? extends TFlowElement>> flowElements) {
            this.flowElements = flowElements;
        }

        public TActivity getActivityRef() {
            return this.tActivityRef;
        }

        public TEvent getEventRef() {
            return this.tEventRef;
        }

        public TGateway getGatewayRef() {
            return this.tGatewayRef;
        }

        @Override
        public void handleAbstractActivity(Activity node) {
            this.handleDefault(node);
        }

        @Override
        public void handleBoundaryEvent(BoundaryEvent boundaryEvent) throws ProjectException {
            TBoundaryEvent tBoundaryEvent = ProcessVisitor.this.objectFactory.createTBoundaryEvent();
            this.tEventRef = tBoundaryEvent;
            Activity boundaryActivity = boundaryEvent.getBoundaryActivity();
            if (boundaryActivity != null) {
                tBoundaryEvent.setAttachedToRef(ProcessVisitor.this.createQNameFor(boundaryActivity.getId()));
            }
            tBoundaryEvent.setCancelActivity(boundaryEvent.cancelActivity());
            this.flowElements.add(ProcessVisitor.this.objectFactory.createBoundaryEvent(tBoundaryEvent));
        }

        @Override
        public void handleManualTask(ManualTask manualTask) {
            TManualTask tManualTask = ProcessVisitor.this.objectFactory.createTManualTask();
            this.tActivityRef = tManualTask;
            this.flowElements.add(ProcessVisitor.this.objectFactory.createManualTask(tManualTask));
        }

        @Override
        public void handleBusinessRuleTask(BusinessRuleTask businessRuleTask) {
            String functionName;
            CatalogMember function;
            String businessRuleName;
            TBusinessRuleTask tBusinessRuleTask = ProcessVisitor.this.objectFactory.createTBusinessRuleTask();
            this.tActivityRef = tBusinessRuleTask;
            TBusinessRuleTaskData businessRuleData = ProcessVisitor.this.extensionsFactory.createTBusinessRuleTaskData();
            BusinessRule businessRule = businessRuleTask.getBusinessRule();
            if (businessRule != null && !Str.isEmpty(businessRuleName = businessRuleTask.getBusinessRuleName())) {
                businessRuleData.setBusinessRuleName(businessRuleName);
            }
            if ((function = businessRuleTask.getFunction()) != null && !Str.isEmpty(functionName = businessRuleTask.getFunctionName())) {
                businessRuleData.setFunctionName(functionName);
            }
            if (businessRule != null || function != null) {
                TOracleExtensions oracleExt = ProcessVisitor.this.getOracleExtensionsFor(tBusinessRuleTask);
                oracleExt.setBusinessRuleTaskData(businessRuleData);
            }
            this.flowElements.add(ProcessVisitor.this.objectFactory.createBusinessRuleTask(tBusinessRuleTask));
        }

        @Override
        public void handleUserTask(UserTask userTask) {
            TUserTask tUserTask = ProcessVisitor.this.objectFactory.createTUserTask();
            this.tActivityRef = tUserTask;
            tUserTask.setImplementation(TUserTaskImplementation.OTHER);
            ProcessVisitor.this.createPerformer(tUserTask, userTask);
            tUserTask.setImplementation(TUserTaskImplementation.OTHER);
            TOracleExtensions extensions = ProcessVisitor.this.getOracleExtensionsFor(tUserTask);
            THumanTask humanTask = ProcessVisitor.this.extensionsFactory.createTHumanTask();
            HumanTask task = userTask.getHumanTask();
            if (task != null) {
                humanTask.setHumanTaskReference(task.getId());
            }
            humanTask.setUsesTransformations(userTask.usesTransformations());
            extensions.setHumanTask(humanTask);
            this.flowElements.add(ProcessVisitor.this.objectFactory.createUserTask(tUserTask));
        }

        @Override
        public void handleServiceTask(ServiceTask serviceTask) {
            String operationName;
            CatalogMember operation;
            String participantName;
            TServiceTask tServiceTask = ProcessVisitor.this.objectFactory.createTServiceTask();
            this.tActivityRef = tServiceTask;
            CatalogObject participant = serviceTask.getParticipant();
            if (participant != null && !Str.isEmpty(participantName = serviceTask.getParticipantName())) {
                tServiceTask.setServiceRef(ProcessVisitor.this.createQNameFor(participantName));
            }
            if ((operation = serviceTask.getOperation()) != null && !Str.isEmpty(operationName = serviceTask.getOperationName())) {
                tServiceTask.setOperationRef(ProcessVisitor.this.createQNameFor(operationName));
            }
            this.flowElements.add(ProcessVisitor.this.objectFactory.createServiceTask(tServiceTask));
        }

        @Override
        public void handleReceiveTask(ReceiveTask receiveTask) {
            String operationName;
            CatalogMember operation;
            String participantName;
            TReceiveTask tReceiveTask = ProcessVisitor.this.objectFactory.createTReceiveTask();
            this.tActivityRef = tReceiveTask;
            tReceiveTask.setInstantiate(receiveTask.isInstantiate());
            CatalogObject participant = receiveTask.getParticipant();
            if (participant != null && !Str.isEmpty(participantName = receiveTask.getParticipantName())) {
                tReceiveTask.setMessageRef(ProcessVisitor.this.createQNameFor(participantName));
            }
            if ((operation = receiveTask.getOperation()) != null && !Str.isEmpty(operationName = receiveTask.getOperationName())) {
                tReceiveTask.setOperationRef(ProcessVisitor.this.createQNameFor(operationName));
            }
            this.flowElements.add(ProcessVisitor.this.objectFactory.createReceiveTask(tReceiveTask));
        }

        @Override
        public void handleSendTask(SendTask sendTask) {
            String operationName;
            CatalogMember operation;
            String participantName;
            TSendTask tSendTask = ProcessVisitor.this.objectFactory.createTSendTask();
            this.tActivityRef = tSendTask;
            CatalogObject participant = sendTask.getParticipant();
            if (participant != null && !Str.isEmpty(participantName = sendTask.getParticipantName())) {
                tSendTask.setMessageRef(ProcessVisitor.this.createQNameFor(participantName));
            }
            if ((operation = sendTask.getOperation()) != null && !Str.isEmpty(operationName = sendTask.getOperationName())) {
                tSendTask.setOperationRef(ProcessVisitor.this.createQNameFor(operationName));
            }
            this.flowElements.add(ProcessVisitor.this.objectFactory.createSendTask(tSendTask));
        }

        @Override
        public void handleScriptTask(ScriptTask scriptTask) {
            TScriptTask tScriptTask = ProcessVisitor.this.objectFactory.createTScriptTask();
            this.tActivityRef = tScriptTask;
            tScriptTask.setScriptLanguage(scriptTask.getLanguage());
            TScript script = ProcessVisitor.this.objectFactory.createTScript();
            script.getContent().add(scriptTask.getScript());
            tScriptTask.setScript(script);
            this.flowElements.add(ProcessVisitor.this.objectFactory.createScriptTask(tScriptTask));
        }

        @Override
        public void handleCallActivity(CallActivity callActivity) {
            TCallActivity tCallActivity = ProcessVisitor.this.objectFactory.createTCallActivity();
            this.tActivityRef = tCallActivity;
            Process process = callActivity.getCalledElement();
            if (process != null) {
                tCallActivity.setCalledElement(ProcessVisitor.this.createQNameFor(process.getId()));
            }
            this.flowElements.add(ProcessVisitor.this.objectFactory.createCallActivity(tCallActivity));
        }

        @Override
        public void handleSubprocess(Subprocess subprocess) throws ProjectException {
            TSubProcess tSubProcess = ProcessVisitor.this.objectFactory.createTSubProcess();
            this.tActivityRef = tSubProcess;
            this.flowElements.add(ProcessVisitor.this.objectFactory.createSubProcess(tSubProcess));
            tSubProcess.setTriggeredByEvent(subprocess.isTriggeredByEvent());
            ProcessVisitor.this.fillSubprocessData(subprocess, tSubProcess);
        }

        @Override
        public void handleStartEvent(StartEvent startEvent) throws ProjectException {
            TStartEvent tStartEvent = ProcessVisitor.this.objectFactory.createTStartEvent();
            this.tEventRef = tStartEvent;
            tStartEvent.setIsInterrupting(startEvent.isInterrupting());
            this.flowElements.add(ProcessVisitor.this.objectFactory.createStartEvent(tStartEvent));
        }

        @Override
        public void handleEndEvent(EndEvent endEvent) {
            TEndEvent tEndEvent = ProcessVisitor.this.objectFactory.createTEndEvent();
            this.tEventRef = tEndEvent;
            this.flowElements.add(ProcessVisitor.this.objectFactory.createEndEvent(tEndEvent));
        }

        @Override
        public void handleCatchIntermediateEvent(CatchEvent event) throws ProjectException {
            TIntermediateCatchEvent tIntCatchEvent = ProcessVisitor.this.objectFactory.createTIntermediateCatchEvent();
            this.tEventRef = tIntCatchEvent;
            this.flowElements.add(ProcessVisitor.this.objectFactory.createIntermediateCatchEvent(tIntCatchEvent));
        }

        @Override
        public void handleIntermediateThrowEvent(ThrowEvent throwEvent) throws ProjectException {
            TIntermediateThrowEvent tIntThrowEvent = ProcessVisitor.this.objectFactory.createTIntermediateThrowEvent();
            this.tEventRef = tIntThrowEvent;
            this.flowElements.add(ProcessVisitor.this.objectFactory.createIntermediateThrowEvent(tIntThrowEvent));
        }

        @Override
        public void handleExclusiveGateway(ExclusiveGateway exclusiveGateway) throws ProjectException {
            TExclusiveGateway tExclusiveGateway = ProcessVisitor.this.objectFactory.createTExclusiveGateway();
            this.tGatewayRef = tExclusiveGateway;
            this.flowElements.add(ProcessVisitor.this.objectFactory.createExclusiveGateway(tExclusiveGateway));
        }

        @Override
        public void handleInclusiveGateway(InclusiveGateway inclusiveGateway) throws ProjectException {
            TInclusiveGateway tInclusiveGateway = ProcessVisitor.this.objectFactory.createTInclusiveGateway();
            this.tGatewayRef = tInclusiveGateway;
            this.flowElements.add(ProcessVisitor.this.objectFactory.createInclusiveGateway(tInclusiveGateway));
        }

        @Override
        public void handleParallelGateway(ParallelGateway parallelGateway) throws ProjectException {
            TParallelGateway tParallelGateway = ProcessVisitor.this.objectFactory.createTParallelGateway();
            this.tGatewayRef = tParallelGateway;
            this.flowElements.add(ProcessVisitor.this.objectFactory.createParallelGateway(tParallelGateway));
        }

        @Override
        public void handleEventBasedGateway(EventBasedGateway eventBasedGateway) throws ProjectException {
            TEventBasedGateway tEventBasedGateway = ProcessVisitor.this.objectFactory.createTEventBasedGateway();
            this.tGatewayRef = tEventBasedGateway;
            tEventBasedGateway.setInstantiate(eventBasedGateway.isInstantiate());
            tEventBasedGateway.setEventGatewayType(TEventBasedGatewayType.fromValue(Str.capitalize(eventBasedGateway.getType().toString().toLowerCase())));
            this.flowElements.add(ProcessVisitor.this.objectFactory.createEventBasedGateway(tEventBasedGateway));
        }

        @Override
        public void handleComplexGateway(ComplexGateway complexGateway) throws ProjectException {
            TComplexGateway tComplexGateway = ProcessVisitor.this.objectFactory.createTComplexGateway();
            this.tGatewayRef = tComplexGateway;
            tComplexGateway.setActivationCondition(ProcessVisitor.this.createExtendedTFormalExpression(complexGateway.getActivationCondition()));
            this.flowElements.add(ProcessVisitor.this.objectFactory.createComplexGateway(tComplexGateway));
        }

        private void handleDefault(FlowNode node) {
            TTask tTask = ProcessVisitor.this.objectFactory.createTTask();
            this.tActivityRef = tTask;
            this.flowElements.add(ProcessVisitor.this.objectFactory.createTask(tTask));
        }
    }

    private class PersistenceEventDefinitionHandler
    extends CheckedEventTriggerAdapter {
        private TEvent tEvent;

        PersistenceEventDefinitionHandler(TEvent tEvent) {
            this.tEvent = tEvent;
        }

        public TEvent getTEventRef() {
            return this.tEvent;
        }

        @Override
        public void handleErrorEvent(Event event) throws ProjectException {
            this.fillEventDefinition(event, this.createTErrorEventDefinition(event.getEventDefinition().as(ErrorEventDefinition.class)));
            this.fillEventAssociations(event);
        }

        @Override
        public void handleTerminateEvent(Event event) throws ProjectException {
            this.fillEventDefinition(event, ProcessVisitor.this.objectFactory.createTerminateEventDefinition(ProcessVisitor.this.objectFactory.createTTerminateEventDefinition()));
        }

        @Override
        public void handleSignalEvent(Event event) throws ProjectException {
            String signalId;
            SignalEventDefinition signalEventDefinition = event.getEventDefinition().as(SignalEventDefinition.class);
            TSignalEventDefinition tSignalEventDefinition = ProcessVisitor.this.objectFactory.createTSignalEventDefinition();
            SignalObject signalObject = signalEventDefinition.getSignal();
            String string = signalId = signalObject != null ? signalObject.getText() : "";
            if (!Str.isEmpty(signalId)) {
                tSignalEventDefinition.setSignalRef(ProcessVisitor.this.createQNameFor(signalId));
            }
            TOracleExtensions tOracleExtensions = ProcessVisitor.this.getOracleExtensionsFor(tSignalEventDefinition);
            Expression expression = signalEventDefinition.getExpression();
            tOracleExtensions.getAny().add(ProcessVisitor.this.objectFactory.createFormalExpression(ProcessVisitor.this.createExtendedTFormalExpression(expression)));
            this.fillEventDefinition(event, ProcessVisitor.this.objectFactory.createSignalEventDefinition(tSignalEventDefinition));
            this.fillEventAssociations(event);
        }

        @Override
        public void handleNoneEvent(Event event) throws ProjectException {
            this.fillEventDefinition(event, null);
            this.fillEventAssociations(event);
        }

        @Override
        public void handleMessageEvent(Event event) throws ProjectException {
            MessageEventDefinition messageEventDefinition = event.getEventDefinition().as(MessageEventDefinition.class);
            ConversationEnabled conversationalEvent = (ConversationEnabled)((Object)event);
            TParticipant tParticipant = ProcessVisitor.this.extensionsFactory.createTParticipant();
            tParticipant.setId(conversationalEvent.getParticipantName());
            TMessageEventDefinition tMessageEventDefinition = ProcessVisitor.this.objectFactory.createTMessageEventDefinition();
            String operationName = conversationalEvent.getOperationName();
            if (!Str.isEmpty(operationName)) {
                tMessageEventDefinition.setOperationRef(ProcessVisitor.this.createQNameFor(operationName));
            }
            this.fillEventDefinition(event, ProcessVisitor.this.objectFactory.createMessageEventDefinition(tMessageEventDefinition));
            this.fillEventAssociations(event);
            TOracleExtensions catchEventExtensions = ProcessVisitor.this.getOracleExtensionsFor(this.tEvent);
            catchEventExtensions.setParticipant(tParticipant);
            if (event.isThrowEvent() && messageEventDefinition.returnsErrors()) {
                ErrorEventDefinition errorEventDefinition = messageEventDefinition.getErrorEventDefinition();
                JAXBElement<TErrorEventDefinition> errorJaxb = this.createTErrorEventDefinition(errorEventDefinition);
                TOracleExtensions messageErrorExtensions = ProcessVisitor.this.getOracleExtensionsFor(tMessageEventDefinition);
                messageErrorExtensions.getAny().add(errorJaxb);
            }
        }

        @Override
        public void handleTimerEvent(Event event) throws ProjectException {
            TimerEventDefinition timerEventDefinition = event.getEventDefinition().as(TimerEventDefinition.class);
            TTimerEventDefinition tTimerEventDefinition = ProcessVisitor.this.objectFactory.createTTimerEventDefinition();
            switch (timerEventDefinition.getType()) {
                case TIME_CYCLE: {
                    TFormalExpression tFormalExpression = ProcessVisitor.this.createExtendedTFormalExpression(timerEventDefinition.getTimeCycleExpression());
                    tTimerEventDefinition.setTimeCycle(tFormalExpression);
                    break;
                }
                case TIME_DATE: {
                    TFormalExpression tFormalExpression = ProcessVisitor.this.createExtendedTFormalExpression(timerEventDefinition.getTimeDateExpression());
                    tTimerEventDefinition.setTimeDate(tFormalExpression);
                    break;
                }
            }
            this.fillEventDefinition(event, ProcessVisitor.this.objectFactory.createTimerEventDefinition(tTimerEventDefinition));
        }

        private void fillEventDefinition(Event event, JAXBElement<? extends TEventDefinition> eventDefJaxbElement) {
            if (event.isCatchEvent()) {
                ((TCatchEvent)this.tEvent).setEventDefinition(eventDefJaxbElement);
            } else if (event.isThrowEvent()) {
                ((TThrowEvent)this.tEvent).setEventDefinition(eventDefJaxbElement);
            }
        }

        private void fillEventAssociations(Event event) throws ProjectException {
            if (event.isCatchEvent()) {
                this.fillEventOutAssociations(event.asCatchEvent(), (TCatchEvent)this.tEvent);
            } else if (event.isThrowEvent()) {
                this.fillEventInAssociations(event.asThrowEvent(), (TThrowEvent)this.tEvent);
            }
        }

        private void fillEventInAssociations(ThrowEvent throwEvent, TThrowEvent tThrowEvent) throws ProjectException {
            tThrowEvent.setInputSet(ProcessVisitor.this.objectFactory.createTInputSet());
            if (throwEvent.getEventTriggerType() != EventTriggerType.NONE) {
                ProcessVisitor.this.createDataInputs(throwEvent, throwEvent.getInputArgumentsContainer().getDeclarations(), tThrowEvent.getDataInput(), null, tThrowEvent.getInputSet());
            }
            IncomingDataAssociationFeature incomingDataAssociationFeature = throwEvent.getFeature(IncomingDataAssociationFeature.class);
            ProcessVisitor.this.createInputDataAssociations(throwEvent, incomingDataAssociationFeature, this.tEvent);
        }

        private void fillEventOutAssociations(CatchEvent catchEvent, TCatchEvent tCatchEvent) throws ProjectException {
            tCatchEvent.setOutputSet(ProcessVisitor.this.objectFactory.createTOutputSet());
            if (catchEvent.getEventTriggerType() != EventTriggerType.NONE) {
                ProcessVisitor.this.createDataOutputs(catchEvent, catchEvent.getOutputArgumentsContainer().getDeclarations(), tCatchEvent.getDataOutput(), null, tCatchEvent.getOutputSet());
            }
            OutgoingDataAssociationFeature outgoingDataAssociationFeature = catchEvent.getFeature(OutgoingDataAssociationFeature.class);
            ProcessVisitor.this.createOutDataAssociations(catchEvent, outgoingDataAssociationFeature, this.tEvent);
        }

        private JAXBElement<TErrorEventDefinition> createTErrorEventDefinition(ErrorEventDefinition errorEventDefinition) {
            TErrorEventDefinition tErrorEventDefinition = ProcessVisitor.this.objectFactory.createTErrorEventDefinition();
            ErrorObject errorObject = errorEventDefinition.getError();
            String errorCode = "";
            if (errorObject != null) {
                TOracleExtensions extensions = ProcessVisitor.this.getOracleExtensionsFor(tErrorEventDefinition);
                extensions.setTypeRef(ProcessVisitor.this.createTTypeRef(errorObject));
                TypeDescription td = errorObject.getDelegate();
                if (td.isArray()) {
                    throw new IllegalArgumentException("Array data types are not supported '" + td + "'");
                }
                errorCode = String.valueOf(errorObject.getErrorCode());
            }
            tErrorEventDefinition.setErrorCode(errorCode);
            return ProcessVisitor.this.objectFactory.createErrorEventDefinition(tErrorEventDefinition);
        }
    }
}

