/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.dashboard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.dashboard.model.Measurement;
import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.dashboard.model.drilldown.DrillDown;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.serializers.dashboard.SerializationUtils;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.xml.XmlWriter;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;

public class WidgetSerializer {
    public static void serializeToXml(XmlWriter writer, WidgetPresentationModel presentationModel) throws IOException {
        BusinessVariableData.Range warningRange;
        BusinessVariableData.Range totalRange;
        BusinessVariableData.Range normalRange;
        BusinessVariableData.Range criticalRange;
        FullBorderProperties border;
        writer.startElement("WidgetPresentationModel");
        writer.printAttribute("name", presentationModel.getName());
        writer.printAttribute("title", presentationModel.getTitle());
        writer.printAttribute("type", (Enum)presentationModel.getType());
        writer.printAttribute("subType", (Enum)presentationModel.getSubType());
        writer.printAttribute("typeSelectionAllowed", presentationModel.isTypeSelectionAllowed());
        writer.printAttribute("usrSelectionAllowed", presentationModel.isUsrSelectionAllowed());
        writer.printAttribute("dataLabelFormat", presentationModel.getDataLabelFormat());
        writer.printAttribute("height", presentationModel.getHeight());
        writer.printAttribute("orientation", presentationModel.getOrientation());
        writer.printAttribute("refreshRate", presentationModel.getRefreshRate());
        writer.printAttribute("width", presentationModel.getWidth());
        SerializationUtils.writeColor(writer, "backgroundColor", presentationModel.getBackgroundColor());
        SerializationUtils.writeColor(writer, "criticalRangeColor", presentationModel.getCriticalRangeColor());
        SerializationUtils.writeColor(writer, "foregroundColor", presentationModel.getForegroundColor());
        SerializationUtils.writeColor(writer, "normalRangeColor", presentationModel.getNormalRangeColor());
        SerializationUtils.writeColor(writer, "outlineColor", presentationModel.getOutlineColor());
        SerializationUtils.writeColor(writer, "plotBackgroundColor", presentationModel.getPlotBackgroundColor());
        SerializationUtils.writeColor(writer, "plotOutlineColor", presentationModel.getPlotOutlineColor());
        SerializationUtils.writeColor(writer, "seriesDataLabelColor", presentationModel.getSeriesDataLabelColor());
        SerializationUtils.writeColor(writer, "shadowColor", presentationModel.getShadowColor());
        SerializationUtils.writeColor(writer, "warningRangeColor", presentationModel.getWarningRangeColor());
        SerializationUtils.writeColor(writer, "titleForegroundColor", presentationModel.getTitleForegroundColor());
        SerializationUtils.writeColor(writer, "titleBackgroundColor", presentationModel.getTitleBackgroundColor());
        SerializationUtils.writeFont(writer, "seriesDataLabelFont", presentationModel.getSeriesDataLabelFont());
        SerializationUtils.writeFont(writer, "titleFont", presentationModel.getTitleFont());
        List seriesColor = presentationModel.getSeriesColor();
        if (seriesColor != null) {
            writer.startElement("List");
            for (ColorInfo colorInfo : seriesColor) {
                SerializationUtils.writeColor(writer, null, colorInfo);
            }
            writer.endElement();
        }
        if ((border = presentationModel.getBorder()) != null) {
            SerializationUtils.writeBorder(writer, border);
        }
        if ((criticalRange = presentationModel.getCriticalRange()) != null) {
            criticalRange.serializeToXml("criticalRange", writer);
        }
        if ((normalRange = presentationModel.getNormalRange()) != null) {
            normalRange.serializeToXml("normalRange", writer);
        }
        if ((totalRange = presentationModel.getTotalRange()) != null) {
            totalRange.serializeToXml("totalRange", writer);
        }
        if ((warningRange = presentationModel.getWarningRange()) != null) {
            warningRange.serializeToXml("warningRange", writer);
        }
        writer.startElement("titles");
        writer.printLocalizedElements("title", presentationModel.getLocalizedTitles());
        writer.endElement();
        writer.endElement();
    }

    public static void serializeToXml(XmlWriter writer, Measurement measurement) throws IOException {
        List ranges;
        writer.startElement("Measurement");
        writer.printAttribute("varId", measurement.getVarId());
        writer.printAttribute("operationType", (Enum)measurement.getOperationType());
        writer.printAttribute("kind", (Enum)measurement.getKind());
        CatalogType type = measurement.getType();
        if (type != null) {
            writer.printAttribute("type", type.getText());
        }
        if ((ranges = measurement.getRanges()) != null) {
            writer.startElement("Ranges");
            for (BusinessVariableData.Range range : ranges) {
                if (range == null) continue;
                range.serializeToXml(null, writer);
            }
            writer.endElement();
        }
        writer.endElement();
    }

    public static void serializeToXml(XmlWriter writer, WidgetDataModel dataModel) throws IOException {
        List dimensions;
        Measurement measurement;
        writer.startElement("WidgetDataModel");
        writer.printAttribute("activityId", dataModel.getActivityId());
        writer.printAttribute("processId", dataModel.getProcessId());
        writer.printAttribute("type", (Enum)dataModel.getType());
        writer.printAttribute("valueType", (Enum)dataModel.getValueType());
        DrillDown drillDown = dataModel.getDrillDown();
        if (drillDown != null) {
            drillDown.serializeToXml(writer);
        }
        if ((measurement = dataModel.getMeasurement()) != null) {
            WidgetSerializer.serializeToXml(writer, measurement);
        }
        if ((dimensions = dataModel.getDimensions()) != null) {
            writer.startElement("Dimensions");
            for (Dimension dimension : dimensions) {
                if (dimension == null) continue;
                WidgetSerializer.serializeToXml(writer, dimension);
            }
            writer.endElement();
        }
        writer.endElement();
    }

    public static void serializeToXml(XmlWriter writer, Dimension dimension) throws IOException {
        List ranges;
        writer.startElement("Dimension");
        writer.printAttribute("varId", dimension.getVarId());
        writer.printAttribute("dimensionType", (Enum)dimension.getDimensionType());
        writer.printAttribute("kind", (Enum)dimension.getKind());
        CatalogType type = dimension.getType();
        if (type != null) {
            writer.printAttribute("type", type.getText());
        }
        if ((ranges = dimension.getRanges()) != null) {
            writer.startElement("Ranges");
            for (BusinessVariableData.Range range : ranges) {
                if (range == null) continue;
                range.serializeToXml(null, writer);
            }
            writer.endElement();
        }
        writer.endElement();
    }

    public static void serializeToFile(File file, WidgetModel widgetModel) throws IOException {
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Literals.DEFAULT_ENCODING);
        WidgetSerializer.serializeToFile(fw, widgetModel);
    }

    public static void serializeToFile(String path, WidgetModel model) throws IOException {
        WidgetSerializer.serializeToFile(new File(path), model);
    }

    public static void serializeToFile(Writer w, WidgetModel widgetModel) throws IOException {
        XmlWriter xw = new XmlWriter(w, Literals.DEFAULT_ENCODING);
        WidgetSerializer.serializeToXml(xw, widgetModel);
        xw.flush();
        xw.close();
    }

    public static void serializeToXml(XmlWriter writer, WidgetModel widgetModel) throws IOException {
        WidgetPresentationModel presentationModel;
        writer.startDocument();
        writer.startElement("WidgetModel");
        writer.printAttribute("name", widgetModel.getName());
        WidgetDataModel dataModel = widgetModel.getDataModel();
        if (dataModel != null) {
            WidgetSerializer.serializeToXml(writer, dataModel);
        }
        if ((presentationModel = widgetModel.getPresentationModel()) != null) {
            WidgetSerializer.serializeToXml(writer, presentationModel);
        }
        writer.endElement();
    }

    public static void save(WidgetModel widget) {
        Project project = widget.getProject();
        ProjectRepository repository = RepositoryService.getInstance().getActiveRepository();
        if (repository.isOpen(project)) {
            ProjectWriter projectWriter = project.getWriter();
            try {
                projectWriter.write(new ProjectObject[]{widget});
            }
            catch (ProjectException e) {
                Log.logFatal(e);
            }
        }
    }

    public static void remove(WidgetModel widgetToRemove) {
        Project project = widgetToRemove.getProject();
        ProjectRepository repository = RepositoryService.getInstance().getActiveRepository();
        if (repository.isOpen(project)) {
            ProjectWriter projectWriter = project.getWriter();
            try {
                projectWriter.delete(new ProjectObject[]{widgetToRemove});
            }
            catch (ProjectException e) {
                Log.logFatal(e);
            }
        }
    }
}

