/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.activityguide;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Literals;
import oracle.bpm.project.activityguide.ActivityRefImpl;
import oracle.bpm.project.activityguide.ResourceBundleImpl;
import oracle.bpm.project.activityguide.TranslatableValueImpl;
import oracle.bpm.project.io.activityGuide.jaxb.ObjectFactory;
import oracle.bpm.project.io.activityGuide.jaxb.TActivityGuide;
import oracle.bpm.project.io.activityGuide.jaxb.TMilestone;
import oracle.bpm.project.io.activityGuide.jaxb.TTranslatableValueEnum;
import oracle.bpm.project.io.activityGuide.jaxb.TUserTask;
import oracle.bpm.project.io.fs.ProjectObjectPersistenceManager;
import oracle.bpm.project.io.serializers.activityguide.ActivityGuideVisitor;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.ActivityRef;
import oracle.bpm.project.model.activityguide.DisplayMode;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.activityguide.MilestoneActivity;
import oracle.bpm.project.model.activityguide.ResourceBundle;
import oracle.bpm.project.model.activityguide.TaskAccessMode;
import oracle.bpm.project.model.activityguide.TranslatableValue;
import oracle.bpm.project.model.activityguide.TranslationType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.xmlparser.ParserException;

public class ActivityGuidePersistenceManager
implements ProjectObjectPersistenceManager<ActivityGuide> {
    public static final String ACTIVITY_GUIDE_JAXB_PACKAGE = "fuego.project.io.activityGuide.jaxb";
    private static ActivityGuidePersistenceManager instance;

    private ActivityGuidePersistenceManager() {
    }

    public static synchronized ActivityGuidePersistenceManager getInstance() {
        if (instance == null) {
            instance = new ActivityGuidePersistenceManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ActivityGuide parse(InputStream is, ActivityGuide activityGuide) throws ProjectException {
        Object inputStreamReader = null;
        Object reader = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            Object unmarshalledObject = unmarshaller.unmarshal(is);
            if (!(unmarshalledObject instanceof TActivityGuide)) {
                throw new ParserException("Invalid JAXB element found");
            }
            this.load((TActivityGuide)unmarshalledObject, activityGuide);
        }
        catch (JAXBException e) {
            try {
                throw new ParserException((Throwable)e);
            }
            catch (ParserException e1) {
                e1.printStackTrace();
                StreamUtils.close(is);
            }
        }
        catch (ParserException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    StreamUtils.close(is);
                    throw throwable;
                }
            }
            StreamUtils.close(is);
        }
        StreamUtils.close(is);
        return activityGuide;
    }

    @Override
    public void write(OutputStream os, ActivityGuide activityGuide) throws ProjectException {
        OutputStreamWriter writer = null;
        try {
            ActivityGuideVisitor activityGuideVisitor = new ActivityGuideVisitor();
            activityGuide.visit(activityGuideVisitor);
            writer = new OutputStreamWriter(os, Literals.DEFAULT_ENCODING);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)activityGuideVisitor.getTActivityGuide(), (Writer)writer);
        }
        catch (Exception e) {
            try {
                throw ProjectException.wrap((ProjectObject)activityGuide, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(writer);
                throw throwable;
            }
        }
        StreamUtils.close(writer);
    }

    private void load(TActivityGuide tActivityGuide, ActivityGuide activityGuide) throws ProjectException {
        activityGuide.setId(tActivityGuide.getId());
        if (tActivityGuide.getTitle() != null) {
            if (tActivityGuide.getTitle().getType() == TTranslatableValueEnum.STATIC) {
                activityGuide.setTitle(tActivityGuide.getTitle().getValue());
            } else {
                TranslatableValueImpl translatableTitle = new TranslatableValueImpl(TranslationType.RESOURCE, tActivityGuide.getTitle().getValue());
                activityGuide.setTitle((TranslatableValue)translatableTitle);
            }
        }
        if (tActivityGuide.getDescription() != null) {
            if (tActivityGuide.getDescription().getType() == TTranslatableValueEnum.STATIC) {
                activityGuide.setDescription(tActivityGuide.getDescription().getValue());
            } else {
                TranslatableValueImpl translatableDescription = new TranslatableValueImpl(TranslationType.RESOURCE, tActivityGuide.getDescription().getValue());
                activityGuide.setDescription((TranslatableValue)translatableDescription);
            }
        }
        activityGuide.setRootProcessId(tActivityGuide.getRootProcessRef());
        activityGuide.setDisplayMode(DisplayMode.valueOf(tActivityGuide.getGlobalDisplayMode().name()));
        activityGuide.setTaskAccessMode(TaskAccessMode.valueOf(tActivityGuide.getGlobalTaskAccessMode().name()));
        activityGuide.setIconLocation(tActivityGuide.getIconLocation());
        if (tActivityGuide.getResourceBundle() != null) {
            ResourceBundleImpl resourceBundle = new ResourceBundleImpl(tActivityGuide.getResourceBundle().getName(), tActivityGuide.getResourceBundle().getLocation());
            activityGuide.setResourceBundle((ResourceBundle)resourceBundle);
        }
        this.loadMilestones(tActivityGuide.getMilestone(), activityGuide);
    }

    private void loadMilestones(List<TMilestone> tMilestones, ActivityGuide activityGuide) throws ProjectException {
        for (TMilestone tMilestone : tMilestones) {
            Milestone milestone = activityGuide.createMilestone(tMilestone.getId());
            if (tMilestone.getTitle() != null) {
                if (tMilestone.getTitle().getType() == TTranslatableValueEnum.STATIC) {
                    milestone.setTitle(tMilestone.getTitle().getValue());
                } else {
                    TranslatableValueImpl translatableTitle = new TranslatableValueImpl(TranslationType.RESOURCE, tMilestone.getTitle().getValue());
                    milestone.setTitle((TranslatableValue)translatableTitle);
                }
            }
            if (tMilestone.getDescription() != null) {
                if (tMilestone.getDescription().getType() == TTranslatableValueEnum.STATIC) {
                    milestone.setDescription(tMilestone.getDescription().getValue());
                } else {
                    TranslatableValueImpl translatableDescription = new TranslatableValueImpl(TranslationType.RESOURCE, tMilestone.getDescription().getValue());
                    milestone.setDescription((TranslatableValue)translatableDescription);
                }
            }
            milestone.setDisplayMode(DisplayMode.valueOf(tMilestone.getMilestoneDisplayMode().name()));
            milestone.setTasksRemaining(tMilestone.getTotalTaskLeft());
            milestone.setIconLocation(tMilestone.getIconLocation());
            activityGuide.addChild(milestone);
            this.loadMilestonesActivities(tMilestone, milestone);
        }
    }

    private void loadMilestonesActivities(TMilestone tMilestone, Milestone milestone) throws ProjectException {
        for (Object child : tMilestone.getUserTaskOrMilestone()) {
            if (!(child instanceof TUserTask)) continue;
            TUserTask tUserTask = (TUserTask)child;
            ActivityRefImpl activityRef = new ActivityRefImpl(milestone.getProject(), tUserTask.getProcessIdRef(), tUserTask.getIdRef());
            MilestoneActivity milestoneActivity = milestone.createMilestoneActivity((ActivityRef)activityRef);
            milestoneActivity.setMarkedAsOptional(tUserTask.isMarkedOptional());
            milestoneActivity.setDisplayBlockedIcon(tUserTask.isDisplayBlockedIcon());
            if (tUserTask.getDisplayBlockedIconText() != null) {
                if (tUserTask.getDisplayBlockedIconText().getType() == TTranslatableValueEnum.STATIC) {
                    milestoneActivity.setBlockedIconText(tUserTask.getDisplayBlockedIconText().getValue());
                } else {
                    TranslatableValueImpl blockedIconTranslatableValue = new TranslatableValueImpl(TranslationType.RESOURCE, tUserTask.getDisplayBlockedIconText().getValue());
                    milestoneActivity.setBlockedIconText((TranslatableValue)blockedIconTranslatableValue);
                }
            }
            milestoneActivity.setTasksRemaining(tUserTask.getTotalTaskLeft());
            milestoneActivity.setDisplayMode(DisplayMode.valueOf(tUserTask.getTaskDisplayMode().name()));
            milestoneActivity.setLastTaskInMilestone(tUserTask.isLastTask());
            milestone.addChild(milestoneActivity);
        }
    }
}

