/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.sensor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.analytics.measurement.metadata.model.ListOfElementStates;
import oracle.bpm.analytics.measurement.metadata.model.ObjectFactory;
import oracle.bpm.analytics.measurement.metadata.model.TElementSelection;
import oracle.bpm.analytics.measurement.metadata.model.TElementState;
import oracle.bpm.analytics.measurement.metadata.model.TMeasurementElement;
import oracle.bpm.analytics.measurement.metadata.model.TMeasurementElementType;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.io.sensor.TMeasurementElementBuilder;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.Nullable;

public class BuilderForGenerateProjectEvents
extends TMeasurementElementBuilder<Project> {
    private List<TMeasurementElementBuilder> builderListForGenerateEvents = new ArrayList<TMeasurementElementBuilder>();
    private TElementSelection elementSelection;

    public BuilderForGenerateProjectEvents(Project project, ObjectFactory objectFactory) {
        super(project, objectFactory);
    }

    public void add(TMeasurementElementBuilder builderForGenerateEvents) {
        this.builderListForGenerateEvents.add(builderForGenerateEvents);
    }

    public void setElementSelection(TElementSelection elementSelection) {
        this.elementSelection = elementSelection;
    }

    @Override
    public Collection<TMeasurementElement> build() {
        ArrayList<TMeasurementElement> tMeasurementElements = new ArrayList<TMeasurementElement>();
        TMeasurementElement tMeasurementElement = this.getObjectFactory().createTMeasurementElement();
        tMeasurementElement.setName(((Project)this.getElement()).getId());
        tMeasurementElement.setType(TMeasurementElementType.COMPOSITE);
        tMeasurementElement.setEnabled(true);
        tMeasurementElement.setElementSelection(this.getElementSelection());
        ListOfElementStates listOfElementStates = this.getObjectFactory().createListOfElementStates();
        listOfElementStates.getElementState().add(TElementState.ALL);
        tMeasurementElement.setElementStates(listOfElementStates);
        tMeasurementElements.add(tMeasurementElement);
        return tMeasurementElements;
    }

    public TElementSelection getElementSelection() {
        return this.elementSelection;
    }

    private boolean shouldPersistMeasurementInfo() {
        Sequence<Process> inheritorsProjectDefaultSequence;
        Project project = (Project)this.getElement();
        Collection<Process> processes = project.getProcesses();
        boolean shouldPersist = processes.size() == 0 ? true : CollectionUtils.size(inheritorsProjectDefaultSequence = CollectionUtils.select(processes, new Predicate<Process>(){

            @Override
            public boolean check(@Nullable Process process) {
                return process.getGeneratesEvents().isProjectDefault();
            }
        })) != 0;
        return shouldPersist;
    }
}

