/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.sensor;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.analytics.measurement.metadata.model.ListOfElementStates;
import oracle.bpm.analytics.measurement.metadata.model.ObjectFactory;
import oracle.bpm.analytics.measurement.metadata.model.TElementSelection;
import oracle.bpm.analytics.measurement.metadata.model.TElementState;
import oracle.bpm.analytics.measurement.metadata.model.TMeasurementElement;
import oracle.bpm.analytics.measurement.metadata.model.TMeasurementElementType;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.project.io.sensor.TMeasurementElementBuilder;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ProcessGenerateEvents;

public class BuilderForGenerateEvents
extends TMeasurementElementBuilder<Process> {
    private TElementSelection elementSelection;
    private Iterable<FlowNode> flowNodes;
    private boolean specifyProcessComponent = true;

    public BuilderForGenerateEvents(Process process, ObjectFactory objectFactory) {
        super(process, objectFactory);
    }

    public void setElementSelection(TElementSelection elementSelection) {
        this.elementSelection = elementSelection;
    }

    public boolean isSpecifyProcessComponent() {
        return this.specifyProcessComponent;
    }

    public void setSpecifyProcessComponent(boolean specifyProcessComponent) {
        this.specifyProcessComponent = specifyProcessComponent;
    }

    public void setFlowNodes(Iterable<FlowNode> flowNodes) {
        this.flowNodes = flowNodes;
    }

    public TElementSelection getElementSelection() {
        return this.elementSelection;
    }

    @Override
    public Collection<TMeasurementElement> build() {
        ArrayList<TMeasurementElement> tMeasurementElements = new ArrayList<TMeasurementElement>();
        if (this.isSpecifyProcessComponent() && !this.inheritsParent()) {
            TMeasurementElement tMeasurementElement = this.getObjectFactory().createTMeasurementElement();
            tMeasurementElement.setName(((Process)this.getElement()).getId());
            tMeasurementElement.setType(TMeasurementElementType.COMPONENT);
            tMeasurementElement.setEnabled(true);
            tMeasurementElement.setComponentName(((Process)this.getElement()).getId());
            tMeasurementElement.setElementSelection(this.getElementSelection());
            ListOfElementStates listOfElementStates = this.getObjectFactory().createListOfElementStates();
            listOfElementStates.getElementState().add(TElementState.ALL);
            tMeasurementElement.setElementStates(listOfElementStates);
            tMeasurementElements.add(tMeasurementElement);
        }
        for (FlowNode flowNode : this.getFlowNodes()) {
            TMeasurementElement tMeasurementElement = this.getObjectFactory().createTMeasurementElement();
            tMeasurementElement.setName(flowNode.getId());
            tMeasurementElement.setType(TMeasurementElementType.ELEMENT);
            tMeasurementElement.setEnabled(true);
            tMeasurementElement.setComponentName(((Process)this.getElement()).getId());
            TElementSelection tElementSelection = TElementSelection.NONE;
            switch (flowNode.getGenerateEvents()) {
                case DO_NOT_GENERATE_EVENTS: {
                    tElementSelection = TElementSelection.NONE;
                    break;
                }
                case GENERATE_EVENTS: {
                    tElementSelection = TElementSelection.ALL;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            tMeasurementElement.setElementSelection(tElementSelection);
            ListOfElementStates listOfElementStates = this.getObjectFactory().createListOfElementStates();
            listOfElementStates.getElementState().add(TElementState.ALL);
            tMeasurementElement.setElementStates(listOfElementStates);
            tMeasurementElement.setElementId(flowNode.getId());
            tMeasurementElements.add(tMeasurementElement);
        }
        return tMeasurementElements;
    }

    private boolean inheritsParent() {
        return ((Process)this.getElement()).getGeneratesEvents() == ProcessGenerateEvents.PROJECT_DEFAULT;
    }

    private Iterable<FlowNode> getFlowNodes() {
        if (this.flowNodes == null) {
            this.flowNodes = CollectionUtils.emptyIterable();
        }
        return this.flowNodes;
    }
}

