/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.recognizer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import oracle.bpm.project.io.recognizer.InputSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlInputSource
implements InputSource {
    private final URL url;

    private UrlInputSource(@NotNull URL url) {
        this.url = url;
    }

    public static UrlInputSource create(@NotNull URL url) {
        return new UrlInputSource(url);
    }

    @Override
    @Nullable
    public String getFileName() {
        return this.url.getFile();
    }

    @Override
    @Nullable
    public InputStream open() throws IOException {
        return this.url.openStream();
    }

    @Override
    public boolean isFolder() {
        boolean result;
        try {
            File file = new File(this.url.toURI());
            result = file.isDirectory();
        }
        catch (URISyntaxException e) {
            result = false;
        }
        return result;
    }
}

