/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.recognizer;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.bpm.lang.Str;
import oracle.bpm.project.io.recognizer.InputSource;
import oracle.bpm.project.io.recognizer.Recognizer;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.dashboard.WidgetModel;
import oracle.bpm.project.model.forms.Form;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.model.presentation.views.ActivityView;
import oracle.bpm.project.model.presentation.views.ApplicationsView;
import oracle.bpm.project.model.presentation.views.AttachmentsView;
import oracle.bpm.project.model.presentation.views.FolderView;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.processes.BpelProcess;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.dataassociations.XSLTransformation;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.variables.BusinessParameter;

class FileExtensionRecognizer
extends Recognizer.Default {
    private final Map<String, Class<? extends ProjectObject>> extensionToClass = new TreeMap<String, Class<? extends ProjectObject>>(String.CASE_INSENSITIVE_ORDER);

    FileExtensionRecognizer() {
        this.fillExtensionsMap();
    }

    @Override
    public Class<? extends ProjectObject> recognize(InputSource inputSource) {
        Class<? extends ProjectObject> result = null;
        String extension = this.getExtension(inputSource);
        if (!Str.isEmpty(extension)) {
            result = this.getFromMap(extension);
        }
        return result;
    }

    String[] getRecognizedExtensions() {
        Set<String> extensions = this.extensionToClass.keySet();
        return extensions.toArray(new String[extensions.size()]);
    }

    private void fillExtensionsMap() {
        this.putToMap(".xpdl", Process.class);
        this.putToMap(".bpmn", Process.class);
        this.putToMap(".bpel", BpelProcess.class);
        this.putToMap(".wsdl", CatalogObject.class);
        this.putToMap(".xpsi", ProjectSimulation.class);
        this.putToMap(".xsim", ModelSimulation.class);
        this.putToMap(".xevdl", ProjectDataObject.class);
        this.putToMap(".xbvdl", ProjectDataObject.class);
        this.putToMap(".xbpdl", BusinessParameter.class);
        this.putToMap(".xml", null);
        this.putToMap(".xprdl", Presentation.class);
        this.putToMap(".xapdl", ApplicationsView.class);
        this.putToMap(".xaidl", ActivityView.class);
        this.putToMap(".xatdl", AttachmentsView.class);
        this.putToMap(".xidl", InstancesView.class);
        this.putToMap(".xfdl", FolderView.class);
        this.putToMap(".xwdl", WidgetModel.class);
        this.putToMap(".form", Form.class);
        this.putToMap(".agdl", ActivityGuide.class);
        this.putToMap(".xsl", XSLTransformation.class);
    }

    private void putToMap(String extension, Class<? extends ProjectObject> objectClass) {
        this.extensionToClass.put(this.sanitizeExtension(extension), objectClass);
    }

    private Class<? extends ProjectObject> getFromMap(String extension) {
        return this.extensionToClass.get(this.sanitizeExtension(extension));
    }
}

