/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.mem;

import java.io.File;
import java.net.URI;
import oracle.bpm.extensionpoint.metadata.ProjectRepositoryMetadata;
import oracle.bpm.project.io.FileSystemTokens;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.mem.MemoryProjectLoader;
import oracle.bpm.project.io.mem.MemoryProjectWriter;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

@ProjectRepositoryMetadata(type="memory")
public class MemoryProjectRepository
extends AbstractProjectRepository {
    public MemoryProjectRepository() {
        this.setReadOnly(true);
    }

    @Override
    public Project create(String projectName) throws ProjectException {
        return this.create(this.getDefaultBaseDir().toURI(), projectName);
    }

    @Override
    public File getDefaultBaseDir() {
        return FileSystemTokens.getDefaultProjectsDir();
    }

    @Override
    protected ProjectFileSystem createFileSystem(Project project, URI baseLocation) throws ProjectException {
        return null;
    }

    @Override
    protected ProjectLoader createLoader(Project project, @NotNull ProjectFileSystem fileSystem) throws ProjectException {
        return new MemoryProjectLoader(project, this);
    }

    @Override
    protected ProjectWriter createWriter(Project project, @NotNull ProjectFileSystem fileSystem) throws ProjectException {
        return new MemoryProjectWriter(project);
    }
}

