/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.Literals;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.io.serializers.dashboard.WidgetSerializer;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.dashboard.WidgetModel;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

@ProjectObjectWriterMetadata(objectClasses={WidgetModel.class})
public class WidgetWriter
extends AbstractWriter {
    @Override
    public void write(ProjectObject object, OutputStream outputStream) throws IOException {
        WidgetModel widget = (WidgetModel)object;
        OutputStreamWriter osw = new OutputStreamWriter(outputStream, Literals.DEFAULT_ENCODING);
        WidgetSerializer.serializeToFile(osw, (oracle.bpm.dashboard.model.WidgetModel)widget);
        osw.flush();
    }

    @Override
    protected VFile createFile(@NotNull ProjectObject projectObject) throws ProjectException {
        WidgetModel widget = (WidgetModel)projectObject;
        ProjectFileSystem pfs = widget.getProject().getWriter().getProjectFileSystem();
        String fileName = widget.getName() + '.' + ".xwdl";
        return pfs.getDataFileSystem().createFile(pfs.getDefaultFolder(WidgetModel.class), fileName);
    }
}

