/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.IOException;
import java.net.MalformedURLException;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.io.fs.msg.ProjectIoMsg;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.fojsp.WebContainer;
import org.jetbrains.annotations.NotNull;

@ProjectObjectWriterMetadata(objectClasses={WebContainer.class})
public class WebContainerWriter
extends AbstractWriter {
    @Override
    public VFile write(ProjectObject projectObject) throws ProjectException {
        assert (projectObject instanceof WebContainer) : "projectObject must be instance of WebContainer";
        try {
            WebContainer webContainer = (WebContainer)projectObject;
            VFile newFolder = this.getFile(webContainer);
            if (newFolder.exists()) {
                throw new ProjectException(projectObject, ProjectIoMsg.PRJ_00067(newFolder.getName()));
            }
            if (!newFolder.mkdirs()) {
                throw new ProjectException(projectObject, ProjectIoMsg.CANNOT_CREATE_FOLDER(newFolder.getCanonicalPath()));
            }
            return newFolder;
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            throw ProjectException.wrap(projectObject, e);
        }
    }

    @Override
    protected VFile createFile(@NotNull ProjectObject projectObject) throws ProjectException {
        assert (projectObject instanceof WebContainer) : "projectObject must be instance of WebContainer";
        VFileSystem fs = projectObject.getProject().getWriter().getProjectFileSystem().getDataFileSystem();
        return projectObject.getPath().getVFile(fs.getRoot());
    }
}

