/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.Literals;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.io.sensor.MeasurementsFileGenerator;
import oracle.bpm.project.io.serializers.organization.ProjectObjectSerializerFactory;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

@ProjectObjectWriterMetadata(objectClasses={ProjectPreferences.class})
public class ProjectPreferencesWriter
extends AbstractWriter {
    @Override
    public void write(ProjectObject object, OutputStream outputStream) throws IOException, ProjectException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, Literals.DEFAULT_ENCODING);
        ProjectObjectSerializerFactory.getSerializer(object).write(writer, object);
        MeasurementsFileGenerator fileGenerator = new MeasurementsFileGenerator(object.getProject());
        fileGenerator.generateFile();
        writer.close();
    }

    @Override
    protected VFile createFile(@NotNull ProjectObject projectObject) throws ProjectException {
        assert (projectObject instanceof ProjectPreferences) : "projectObject must be instance of ProjectPreferences";
        return projectObject.getProject().getWriter().getProjectFileSystem().getDataFileSystem().createFile(Path.CONFIG.create("preferences.xml").toString());
    }
}

