/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.catalog.composite.CompositeAccessorFactory;
import oracle.bpm.project.interfaces.ProcessWsdlWriter;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.io.sensor.MeasurementsFileGenerator;
import oracle.bpm.project.io.serializers.model.ModelFormat;
import oracle.bpm.project.io.serializers.model.documentation.DocumentationFileGenerator;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.util.FileUtils;
import org.jetbrains.annotations.NotNull;

@ProjectObjectWriterMetadata(objectClasses={Process.class})
public class ProcessWriter
extends AbstractWriter {
    @Override
    public VFile write(ProjectObject projectObject) throws ProjectException {
        VFile result = super.write(projectObject);
        try {
            Process process = (Process)projectObject;
            if (!ProcessContent.isDefaultProcess((Process)process)) {
                if (!ProcessWriter.hasCycles(process)) {
                    ProcessWsdlWriter.write((Process)process);
                    if (process.getProject() != null) {
                        CompositeAccessorFactory.createCompositeUpdater((Process)process).updateComposite();
                    }
                }
                MeasurementsFileGenerator measurementsFileGenerator = new MeasurementsFileGenerator(projectObject.getProject());
                measurementsFileGenerator.generateFile();
                DocumentationFileGenerator.generateDocumentationFileFor(process);
            }
        }
        catch (Exception unexpected) {
            Log.logSevere(unexpected);
        }
        return result;
    }

    @Override
    public void write(ProjectObject object, OutputStream outputStream) throws IOException, ProjectException {
        Process content = (Process)object;
        ModelFormat format = ModelFormat.Extension.get(SchemaType.PROCESS);
        format.writeXml(content, new OutputStreamWriter(outputStream, Literals.DEFAULT_ENCODING));
    }

    @Override
    public void delete(@NotNull ProjectObject projectObject) throws ProjectException {
        Process process = (Process)projectObject;
        VFile file = this.getFile(process);
        this.delete(file, process);
        if (!ProcessContent.isDefaultProcess((Process)process)) {
            String artifactName = FileUtils.removeExtension((String)file.getName());
            String wsdlFileName = artifactName + ".wsdl";
            VFile wsdlVFile = file.getFileSystem().createFile(wsdlFileName);
            this.delete(wsdlVFile, process);
            CompositeAccessorFactory.createCompositeUpdater((Process)process).delete();
            MeasurementsFileGenerator measurementsFileGenerator = new MeasurementsFileGenerator(projectObject.getProject());
            measurementsFileGenerator.generateFile();
            VFile docFile = DocumentationFileGenerator.getDocumentationsFile(process);
            this.delete(docFile, process);
        }
    }

    @Override
    protected VFile createFile(@NotNull ProjectObject projectObject) throws ProjectException {
        assert (projectObject instanceof Process) : "projectObject must be instance of Process";
        Process process = (Process)projectObject;
        VFile folder = this.getContainerFolder(process);
        String extension = SchemaType.getExtensionFor((SchemaType)SchemaType.PROCESS);
        String fileName = process.getId() + extension;
        ProjectWriter writer = projectObject.getProject().getWriter();
        VFileSystem dataFileSystem = writer.getProjectFileSystem().getDataFileSystem();
        return dataFileSystem.createFile(folder, fileName);
    }

    private static boolean hasCycles(Process process) {
        return ProcessWriter.hasCycles(process, new ArrayDeque<Process>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasCycles(Process root, Deque<Process> path) {
        if (path.contains(root)) {
            return true;
        }
        try {
            path.push(root);
            for (Process process : ModelUtils.getCalledProcesses(root)) {
                if (!ProcessWriter.hasCycles(process, path)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            path.pop();
        }
        return false;
    }
}

