/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.holidays.Holiday;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.Day;
import oracle.bpm.lang.Id;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.WorkDaySchedule;
import oracle.bpm.lang.WorkWeek;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.identity.ApplicationRole;
import oracle.bpm.project.model.identity.Group;
import oracle.bpm.project.model.identity.MemberContainer;
import oracle.bpm.project.model.identity.User;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.HolidayRuleAssignment;
import oracle.bpm.project.model.organization.OrganizationalUnitRef;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.services.organization.model.ApplicationRoleType;
import oracle.bpm.services.organization.model.ApplicationRoles;
import oracle.bpm.services.organization.model.CalendarRules;
import oracle.bpm.services.organization.model.HolidayPatternEnum;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.HolidayRules;
import oracle.bpm.services.organization.model.HolidayType;
import oracle.bpm.services.organization.model.MemberType;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.OrganizationalUnits;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.ProcessRoleType;
import oracle.bpm.services.organization.model.WeekDaysEnum;
import oracle.bpm.services.organization.model.WorkPeriodType;
import oracle.bpm.services.organization.model.WorkdayListType;
import oracle.bpm.services.organization.model.WorkdayType;
import oracle.bpm.xml.JaxbHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ProjectObjectWriterMetadata(objectClasses={Organization.class})
public class OrganizationWriter
extends AbstractWriter {
    @Nullable
    private DatatypeFactory datatypeFactory;
    private final ObjectFactory objectFactory = new ObjectFactory();
    private static final JAXBContext JAXB_CONTEXT = JaxbHelper.newContext(ObjectFactory.class);

    @Override
    public void write(ProjectObject organization, OutputStream outputStream) throws ProjectException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(outputStream, Literals.DEFAULT_ENCODING);
            Marshaller marshaller = JAXB_CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
            writer.write("<?oracleBPM version=\"" + Id.getAbsoluteVersion() + "\" fileRevision=\"" + "20090820" + "\"?>\n");
            marshaller.marshal((Object)this.visit((Organization)organization), (Writer)writer);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw ProjectException.wrap(organization, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(writer);
                throw throwable;
            }
        }
        StreamUtils.close(writer);
    }

    @Override
    public VFile getFile(@NotNull ProjectObject projectObject) throws ProjectException {
        ProjectFileSystem fileSystem = projectObject.getProject().getLoader().getProjectFileSystem();
        return fileSystem.getDataFileSystem().createFile(fileSystem.getDataFileSystem().getRoot(), "organization.xml");
    }

    private static DatatypeFactory buildDatatypeFactory() {
        try {
            return DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    private DatatypeFactory getDatatypeFactory() {
        DatatypeFactory result = this.datatypeFactory;
        if (result == null) {
            this.datatypeFactory = result = OrganizationWriter.buildDatatypeFactory();
        }
        return result;
    }

    private XMLGregorianCalendar newXMLGregorianCalendar(GregorianCalendar calendar) {
        return this.getDatatypeFactory().newXMLGregorianCalendar(calendar);
    }

    private oracle.bpm.services.organization.model.Organization visit(Organization organization) throws ProjectException {
        oracle.bpm.services.organization.model.Organization tOrganization = this.objectFactory.createOrganization();
        tOrganization.setApplicationRoles(this.getTRoles(organization, tOrganization));
        tOrganization.setCalendarRules(this.getTCalendarRules(organization));
        tOrganization.setHolidayRules(this.getTHolidayRules(organization));
        tOrganization.setOrganizationalUnits(this.getTOrganizationalUnits(organization));
        OrganizationalUnitRef ouMappingRef = organization.getOrganizationalChart().getOrganizationalUnitMapping();
        if (ouMappingRef != null) {
            tOrganization.setProcessOrganizationalUnitId(ouMappingRef.getId());
            tOrganization.setProcessOrganizationalUnitName(ouMappingRef.getName());
        }
        return tOrganization;
    }

    private ApplicationRoles getTRoles(Organization organization, oracle.bpm.services.organization.model.Organization tOrganization) throws ProjectException {
        ApplicationRoles applicationRoles = this.objectFactory.createApplicationRoles();
        List applictionRolesList = applicationRoles.getApplicationRole();
        for (Role role : organization.getDeclaredRoles()) {
            ApplicationRoleType applicationRoleType = this.objectFactory.createApplicationRoleType();
            applicationRoleType.setName(organization.getProject().getName() + "." + role.getId());
            Lane lane = this.findLane(organization.getProject(), role);
            applicationRoleType.setIsProcessRole(lane != null);
            ProcessRoleType processRoleType = this.objectFactory.createProcessRoleType();
            processRoleType.setId(role.getId());
            processRoleType.setName(role.getName());
            applicationRoleType.setProcessRole(processRoleType);
            this.addApplicationRoleMemberTypes(role, applicationRoleType.getMember());
            applictionRolesList.add(applicationRoleType);
        }
        if (organization.findChild(Role.class, "ProcessOwner") == null) {
            ApplicationRoleType applicationRoleType = this.objectFactory.createApplicationRoleType();
            applicationRoleType.setName(organization.getProject().getName() + "." + "ProcessOwner");
            applicationRoleType.setIsProcessRole(false);
            ProcessRoleType processRoleType = this.objectFactory.createProcessRoleType();
            processRoleType.setId("ProcessOwner");
            processRoleType.setName("Process Owner");
            applicationRoleType.setProcessRole(processRoleType);
            applictionRolesList.add(applicationRoleType);
        }
        return applicationRoles;
    }

    private void addApplicationRoleMemberTypes(MemberContainer memberContainer, List<PrincipleRefType> memberTypeList) {
        PrincipleRefType principleRefType;
        for (User user : memberContainer.getUsers()) {
            principleRefType = this.objectFactory.createPrincipleRefType();
            principleRefType.setName(user.getName());
            principleRefType.setRealm(user.getRealm());
            principleRefType.setType(ParticipantTypeEnum.USER);
            memberTypeList.add(principleRefType);
        }
        for (Group group : memberContainer.getGroups()) {
            principleRefType = this.objectFactory.createPrincipleRefType();
            principleRefType.setName(group.getName());
            principleRefType.setRealm(group.getRealm());
            principleRefType.setType(ParticipantTypeEnum.GROUP);
            memberTypeList.add(principleRefType);
        }
        for (ApplicationRole applicationRole : memberContainer.getApplicationRoles()) {
            principleRefType = this.objectFactory.createPrincipleRefType();
            principleRefType.setName(applicationRole.getName());
            principleRefType.setApplicationContext(applicationRole.getApplicationContext());
            principleRefType.setType(ParticipantTypeEnum.APPROLE);
            memberTypeList.add(principleRefType);
        }
    }

    private Lane findLane(Project project, Role role) {
        for (Process process : project.getProcesses()) {
            Lane lane = process.findLane(role.getId());
            if (lane == null) continue;
            return lane;
        }
        return null;
    }

    private OrganizationalUnits getTOrganizationalUnits(Organization organization) {
        OrganizationalUnits tOrganizationalUnits = this.objectFactory.createOrganizationalUnits();
        for (oracle.bpm.project.model.organization.OrganizationalUnit ou : organization.getOrganizationalUnits()) {
            OrganizationalUnit tOu = this.objectFactory.createOrganizationalUnit();
            tOu.setOrganizationalUnitId(ou.getId());
            tOu.setOrganizationalUnitName(ou.getName());
            tOu.setDescription(ou.getDescription());
            this.addOuMemberTypes(ou, tOu.getMember());
            if (ou.getParent() != null) {
                tOu.setParentOrganizationalUnitId(ou.getParent().getId());
                tOu.setParentOrganizationalUnitName(ou.getParent().getName());
            }
            if (ou.getCalendarRule() != null) {
                tOu.setCalendarRuleId(ou.getCalendarRule().getId());
                tOu.setCalendarRuleName(ou.getCalendarRule().getName());
            }
            tOrganizationalUnits.getOrganizationalUnit().add(tOu);
        }
        return tOrganizationalUnits;
    }

    private void addOuMemberTypes(MemberContainer memberContainer, List<MemberType> memberTypeList) {
        MemberType tMemberType;
        for (User user : memberContainer.getUsers()) {
            tMemberType = this.objectFactory.createMemberType();
            tMemberType.setMemberId(ModelUtils.generateGuid());
            tMemberType.setName(user.getName());
            tMemberType.setRealm(user.getRealm());
            tMemberType.setType(ParticipantTypeEnum.USER);
            memberTypeList.add(tMemberType);
        }
        for (Group group : memberContainer.getGroups()) {
            tMemberType = this.objectFactory.createMemberType();
            tMemberType.setMemberId(ModelUtils.generateGuid());
            tMemberType.setName(group.getName());
            tMemberType.setRealm(group.getRealm());
            tMemberType.setType(ParticipantTypeEnum.GROUP);
            memberTypeList.add(tMemberType);
        }
        for (ApplicationRole applicationRole : memberContainer.getApplicationRoles()) {
            tMemberType = this.objectFactory.createMemberType();
            tMemberType.setMemberId(ModelUtils.generateGuid());
            tMemberType.setName(applicationRole.getName());
            tMemberType.setApplicationContext(applicationRole.getApplicationContext());
            tMemberType.setType(ParticipantTypeEnum.APPROLE);
            memberTypeList.add(tMemberType);
        }
    }

    private HolidayRules getTHolidayRules(Organization organization) {
        HolidayRules tHolidayRules = this.objectFactory.createHolidayRules();
        for (oracle.bpm.project.model.organization.HolidayRule hr : organization.getHolidayRules()) {
            HolidayRule tHolidayRule = this.objectFactory.createHolidayRule();
            tHolidayRule.setId(hr.getId());
            tHolidayRule.setName(hr.getName());
            if (hr.getHolidayCalendar() != null) {
                for (Holiday holiday : hr.getHolidayCalendar().getHolidays()) {
                    HolidayType tHolidayType = this.objectFactory.createHolidayType();
                    tHolidayType.setName(holiday.getDescription());
                    tHolidayType.setHolidayPattern(HolidayPatternEnum.fromValue((String)holiday.getType().getValue()));
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(holiday.getDate().dateValue());
                    XMLGregorianCalendar calendar = this.newXMLGregorianCalendar(gregorianCalendar);
                    calendar.setTimezone(Integer.MIN_VALUE);
                    tHolidayType.setHolidayDate(calendar);
                    tHolidayRule.getHolidays().add(tHolidayType);
                }
            }
            tHolidayRules.getHolidayRule().add(tHolidayRule);
        }
        return tHolidayRules;
    }

    private CalendarRules getTCalendarRules(Organization organization) {
        CalendarRules tCalendarRules = this.objectFactory.createCalendarRules();
        for (CalendarRule cr : organization.getCalendarRules()) {
            oracle.bpm.services.organization.model.CalendarRule tCalendarRule = this.objectFactory.createCalendarRule();
            tCalendarRule.setId(cr.getId());
            tCalendarRule.setName(cr.getName());
            tCalendarRule.setTimeZone(cr.getTimeZone());
            HolidayRuleAssignment holidayRuleAssignment = cr.getHolidayRuleAssignment();
            if (holidayRuleAssignment != null && holidayRuleAssignment.getHolidayRule() != null) {
                tCalendarRule.setHolidayRuleId(holidayRuleAssignment.getHolidayRule().getId());
                tCalendarRule.setHolidayRuleName(holidayRuleAssignment.getHolidayRule().getName());
            }
            WorkdayListType tWorkdayList = this.objectFactory.createWorkdayListType();
            for (Day day : Day.values()) {
                WorkWeek workWeek = cr.getWorkWeek();
                WorkDaySchedule workDaySchedule = workWeek.getSchedule(day);
                if (workDaySchedule == null) continue;
                WorkdayType tWorkday = this.objectFactory.createWorkdayType();
                tWorkday.setWeekDay(WeekDaysEnum.valueOf((String)day.toString()));
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                if (workDaySchedule.hasShift(0)) {
                    WorkPeriodType tWorkPeriod0 = this.objectFactory.createWorkPeriodType();
                    gregorianCalendar.setTime(workDaySchedule.getStartTime(0).dateValue());
                    tWorkPeriod0.setStartTime(this.newXMLGregorianCalendar(gregorianCalendar));
                    gregorianCalendar.setTime(workDaySchedule.getFinishTime(0).dateValue());
                    tWorkPeriod0.setEndTime(this.newXMLGregorianCalendar(gregorianCalendar));
                    tWorkday.getWorkPeriod().add(tWorkPeriod0);
                }
                if (workDaySchedule.hasShift(1)) {
                    WorkPeriodType tWorkPeriod1 = this.objectFactory.createWorkPeriodType();
                    gregorianCalendar.setTime(workDaySchedule.getStartTime(1).dateValue());
                    tWorkPeriod1.setStartTime(this.newXMLGregorianCalendar(gregorianCalendar));
                    gregorianCalendar.setTime(workDaySchedule.getFinishTime(1).dateValue());
                    tWorkPeriod1.setEndTime(this.newXMLGregorianCalendar(gregorianCalendar));
                    tWorkday.getWorkPeriod().add(tWorkPeriod1);
                }
                tWorkdayList.getWorkday().add(tWorkday);
            }
            tCalendarRule.setWorkdayList(tWorkdayList);
            tCalendarRules.getCalendarRule().add(tCalendarRule);
        }
        return tCalendarRules;
    }
}

