/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Literals;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.io.serializers.organization.ProjectObjectSerializer;
import oracle.bpm.project.io.serializers.organization.ProjectObjectSerializerFactory;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.deployment.Referral;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.presentation.views.ActivityView;
import oracle.bpm.project.model.presentation.views.ApplicationsView;
import oracle.bpm.project.model.presentation.views.AttachmentsView;
import oracle.bpm.project.model.presentation.views.FolderView;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.variables.BusinessParameter;
import oracle.bpm.util.FileUtils;
import org.jetbrains.annotations.NotNull;

@ProjectObjectWriterMetadata(objectClasses={ProjectDataObject.class, BusinessParameter.class, Group.class, Participant.class, FolderView.class, ActivityView.class, ApplicationsView.class, AttachmentsView.class, FolderView.class, InstancesView.class, Referral.class})
public class OrganizationObjectWriter
extends AbstractWriter {
    @Override
    public void write(ProjectObject projectObject, OutputStream out) throws UnsupportedEncodingException, ProjectException {
        OutputStreamWriter osw = new OutputStreamWriter(out, Literals.DEFAULT_ENCODING);
        ProjectObjectSerializer serializer = ProjectObjectSerializerFactory.getSerializer(projectObject);
        serializer.write(osw, projectObject);
    }

    @Override
    public void delete(@NotNull ProjectObject projectObject) throws ProjectException {
        VFile file = this.getFile(projectObject);
        this.delete(file, projectObject);
        if (projectObject instanceof OrganizationalUnit) {
            VFile folder = file.getFileSystem().createFile(FileUtils.removeExtension((String)file.getCanonicalPath()));
            this.delete(folder, projectObject);
        }
    }

    @Override
    protected VFile getContainerFolder(ProjectObject projectObject) throws ProjectException {
        if (projectObject instanceof OrganizationalUnit) {
            try {
                VFileSystem fs = projectObject.getProject().getWriter().getProjectFileSystem().getDataFileSystem();
                VFile folder = projectObject.getPath().getParent().getVFile(fs.getRoot());
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                return folder;
            }
            catch (IOException e) {
                throw ProjectException.wrap(projectObject, e);
            }
        }
        if (projectObject instanceof OrganizationalChart) {
            VFileSystem fs = projectObject.getProject().getWriter().getProjectFileSystem().getDataFileSystem();
            return Path.ORGANIZATION.getVFile(fs.getRoot());
        }
        return super.getContainerFolder(projectObject);
    }
}

