/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.IOException;
import java.io.OutputStream;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.project.io.fs.ResourceObjectType;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.io.serializers.simulation.ModelSimulationVisitor;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ModelSimulation;
import org.jetbrains.annotations.NotNull;

@ProjectObjectWriterMetadata(objectClasses={ModelSimulation.class})
public class ModelSimulationWriter
extends AbstractWriter {
    @Override
    public void write(ProjectObject projectObject, OutputStream outputStream) throws IOException, ProjectException {
        assert (projectObject instanceof ModelSimulation) : "projectObject must be instance of ModelSimulation";
        ModelSimulationVisitor modelSimulationVisitor = new ModelSimulationVisitor();
        ModelSimulation modelSimulation = (ModelSimulation)projectObject;
        modelSimulation.visit(modelSimulationVisitor);
        modelSimulationVisitor.getPersistentModelSimulation().store(outputStream);
    }

    @Override
    public void delete(ProjectObject projectObject) throws ProjectException {
        super.delete(projectObject);
    }

    @Override
    protected VFile createFile(@NotNull ProjectObject projectObject) throws ProjectException {
        assert (projectObject instanceof ModelSimulation) : "projectObject must be instance of ModelSimulation";
        ModelSimulation modelSimulation = (ModelSimulation)projectObject;
        VFile folder = this.getContainerFolder(modelSimulation);
        ResourceObjectType resourceType = ResourceObjectType.getResourceType(modelSimulation);
        String fileName = modelSimulation.getProcess().getId() + "_" + modelSimulation.getId() + resourceType.getFileExtension();
        return projectObject.getProject().getWriter().getProjectFileSystem().getDataFileSystem().createFile(folder, fileName);
    }
}

