/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.IOException;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.io.fs.msg.ProjectIoMsg;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

@ProjectObjectWriterMetadata(objectClasses={FolderContainer.class})
public class ModelContainerWriter
extends AbstractWriter {
    @Override
    public VFile write(ProjectObject projectObject) throws ProjectException {
        assert (projectObject instanceof FolderContainer) : "projectObject must be instance of ModelContainer";
        try {
            VFile newFolder = this.getFile(projectObject);
            if (!newFolder.exists() && !newFolder.mkdirs()) {
                throw new ProjectException(projectObject, ProjectIoMsg.CANNOT_CREATE_FOLDER(newFolder.getCanonicalPath()));
            }
            return newFolder;
        }
        catch (IOException e) {
            throw ProjectException.wrap(projectObject, e);
        }
    }

    @Override
    protected VFile createFile(@NotNull ProjectObject projectObject) throws ProjectException {
        assert (projectObject instanceof FolderContainer) : "projectObject must be instance of FolderContainer";
        VFileSystem fs = projectObject.getProject().getWriter().getProjectFileSystem().getDataFileSystem();
        return projectObject.getPath().getVFile(fs.getRoot());
    }
}

