/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.Literals;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.forms.Form;
import oracle.bpm.xml.XmlWriter;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.xml.XFormSerializer;
import org.jetbrains.annotations.NotNull;

@ProjectObjectWriterMetadata(objectClasses={Form.class})
public class FormWriter
extends AbstractWriter {
    @Override
    public void write(ProjectObject object, OutputStream outputStream) throws IOException, ProjectException {
        Form form = (Form)object;
        OutputStreamWriter osw = new OutputStreamWriter(outputStream, Literals.DEFAULT_ENCODING);
        XmlWriter writer = new XmlWriter(osw);
        XFormSerializer.serialize((XmlWriter)writer, (XFormPresentation)form.getModel().getPresentation());
        osw.flush();
    }

    @Override
    protected VFile createFile(@NotNull ProjectObject projectObject) throws ProjectException {
        Form form = (Form)projectObject;
        ProjectFileSystem pfs = form.getProject().getWriter().getProjectFileSystem();
        String fileName = form.getName() + ".form";
        return pfs.getDataFileSystem().createFile(pfs.getDefaultFolder(Form.class), fileName);
    }
}

