/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.view.PresentationImpl;
import oracle.bpm.view.io.DirPresentationReader;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXException;

@ProjectObjectLoaderMetadata(objectClasses={Presentation.class})
public class ViewPresentationLoader
extends ProjectObjectLoader<Presentation> {
    private DirPresentationReader dirPresentationReader = new DirPresentationReader();

    @Override
    public Presentation create(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Presentation loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        VFileInputStream inputStream = null;
        Presentation presentation = null;
        try {
            inputStream = new VFileInputStream(file);
            this.dirPresentationReader.clear();
            PresentationImpl presentationImpl = this.dirPresentationReader.parse((InputStream)inputStream);
            presentation = this.getProject().getPresentationManager().create(presentationImpl);
        }
        catch (ParserConfigurationException e) {
            try {
                throw ProjectException.wrap((ProjectObject)this.getProject(), e);
                catch (SAXException e2) {
                    throw ProjectException.wrap((ProjectObject)this.getProject(), e2);
                }
                catch (IOException e3) {
                    throw ProjectException.wrap((ProjectObject)this.getProject(), e3);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(new Closeable[]{inputStream});
                throw throwable;
            }
        }
        StreamUtils.close(new Closeable[]{inputStream});
        return presentation;
    }
}

