/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.io.fs.msg.ProjectIoMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.presentation.views.ActivityView;
import oracle.bpm.project.model.presentation.views.ApplicationsView;
import oracle.bpm.project.model.presentation.views.AttachmentsView;
import oracle.bpm.project.model.presentation.views.FolderView;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.presentation.views.ViewAdapter;
import oracle.bpm.view.ViewImpl;
import oracle.bpm.view.io.DirViewReader;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXException;

@ProjectObjectLoaderMetadata(objectClasses={FolderView.class, ActivityView.class, ApplicationsView.class, AttachmentsView.class, FolderView.class, InstancesView.class})
public class ViewLoader
extends ProjectObjectLoader<View> {
    private DirViewReader dirViewReader = new DirViewReader();

    @Override
    public View create(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public View loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        VFileInputStream inputStream = null;
        ViewImpl view = null;
        try {
            inputStream = new VFileInputStream(file);
            this.dirViewReader.clear();
            view = this.dirViewReader.parse((InputStream)inputStream);
        }
        catch (ParserConfigurationException e) {
            try {
                throw ProjectException.wrap((ProjectObject)this.getProject(), e);
                catch (SAXException e2) {
                    throw ProjectException.wrap((ProjectObject)this.getProject(), e2);
                }
                catch (IOException e3) {
                    throw ProjectException.wrap((ProjectObject)this.getProject(), e3);
                }
                catch (Exception e4) {
                    throw ProgramException.wrap(ProjectIoMsg.VIEW_LOADING_ERROR.getString() + ": " + file.getCanonicalPath(), e4);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(new Closeable[]{inputStream});
                throw throwable;
            }
        }
        StreamUtils.close(new Closeable[]{inputStream});
        if (view == null) {
            return null;
        }
        ViewAdapter viewAdapter = ViewAdapter.create((ViewImpl)view, (Project)this.getProject());
        return viewAdapter;
    }
}

