/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.io.serializers.organization.ParseListener;
import oracle.bpm.project.io.serializers.organization.ProjectFileHandlerFactory;
import oracle.bpm.project.io.serializers.organization.ProjectObjectParser;
import oracle.bpm.project.io.serializers.organization.ProjectSourceHandler;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.deployment.Topology;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@ProjectObjectLoaderMetadata(objectClasses={Topology.class})
public class TopologyLoader
extends ProjectObjectLoader<Topology> {
    private SAXParser saxParser;

    @Override
    public Topology create(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Topology loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        Topology topology;
        VFileInputStream fileInputStream = null;
        try {
            fileInputStream = new VFileInputStream(file);
            InputSource inputSource = new InputSource((InputStream)fileInputStream);
            final ProjectObject[] newProjectObject = new ProjectObject[]{null};
            ProjectSourceHandler handler = ProjectFileHandlerFactory.createProjectHandler(this.getProject(), container);
            handler.addParseListener(new ParseListener(){

                @Override
                public void objectParsed(ProjectObjectParser parser, ProjectObject projectObject) throws ProjectException {
                    newProjectObject[0] = projectObject;
                }

                @Override
                public ProjectObject getObjectParsed() {
                    return null;
                }

                @Override
                public ProjectObjectParser getProjectObjectParser() {
                    return null;
                }
            });
            this.getSaxParser().parse(inputSource, (DefaultHandler)handler);
            topology = (Topology)newProjectObject[0];
        }
        catch (IOException e) {
            try {
                throw ProjectException.wrap((ProjectObject)this.getProject(), e);
                catch (SAXException e2) {
                    throw ProjectException.wrap((ProjectObject)this.getProject(), e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(new Closeable[]{fileInputStream});
                throw throwable;
            }
        }
        StreamUtils.close(new Closeable[]{fileInputStream});
        return topology;
    }

    private SAXParser getSaxParser() {
        if (this.saxParser == null) {
            try {
                this.saxParser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                Log.logDebug(e);
            }
            catch (SAXException e) {
                Log.logDebug(e);
            }
        }
        return this.saxParser;
    }
}

