/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectObjectLoader<T extends ProjectObject> {
    protected Project project;

    public abstract T create(@NotNull ResourceContainer var1, @NotNull VFile var2) throws ProjectException;

    public abstract T loadObject(@NotNull ResourceContainer var1, @NotNull VFile var2) throws ProjectException;

    public static ProjectObjectLoader create(Class<? extends ProjectObject> objectClass, Project project) {
        ExtensionService service = Platform.getExtensionService();
        List<Extension<ProjectObjectLoaderMetadata>> extensions = service.getExtensionsByPoint(ProjectObjectLoaderMetadata.class);
        for (Extension<ProjectObjectLoaderMetadata> extension : extensions) {
            Class<? extends ProjectObject>[] availableClasses;
            for (Class<? extends ProjectObject> availableClass : availableClasses = extension.getMetadata().objectClasses()) {
                if (!availableClass.isAssignableFrom(objectClass)) continue;
                try {
                    ProjectObjectLoader result = extension.instantiateAs(ProjectObjectLoader.class);
                    result.project = project;
                    return result;
                }
                catch (InstantiationException e) {
                    IllegalStateException iae = new IllegalStateException("Could not create loader for class " + objectClass.toString() + ". Because: " + e);
                    iae.initCause(e);
                    throw iae;
                }
            }
        }
        throw new IllegalArgumentException("Could not create loader for class " + objectClass.toString());
    }

    public T loadObject(@NotNull InputStream in) throws ProjectException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public T load(@NotNull Project project, @NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        this.project = project;
        try {
            T projectObject = this.loadObject(container, file);
            ProjectObjectImpl.setAdapter(projectObject, (Object)file);
            ((ResourceObject)projectObject).setDirty(false);
            return projectObject;
        }
        catch (Throwable t) {
            t.printStackTrace();
            ProjectException projectException = ProjectException.wrap((ProjectObject)container, t);
            T brokenObject = this.create(container, file);
            if (brokenObject != null) {
                ProjectObjectImpl.setAdapter(brokenObject, (Object)file);
                if (brokenObject instanceof ProjectObjectImpl) {
                    ProjectObjectImpl impl = (ProjectObjectImpl)brokenObject;
                    impl.setErrors(Arrays.asList(projectException));
                    impl.setBroken(true);
                }
                return brokenObject;
            }
            throw projectException;
        }
    }

    protected Project getProject() {
        return this.project;
    }
}

