/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.io.serializers.model.DefaultModelFormat;
import oracle.bpm.project.io.serializers.model.ModelFormat;
import oracle.bpm.project.io.serializers.model.ModelParseException;
import oracle.bpm.project.io.serializers.model.documentation.DocumentationFileLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.util.FileUtils;
import oracle.bpm.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

@ProjectObjectLoaderMetadata(objectClasses={Process.class})
public class ProcessesLoader
extends ProjectObjectLoader<Process> {
    @Override
    public Process create(@NotNull ResourceContainer container, @NotNull VFile file) {
        String modelId = FileUtils.removeExtension((String)file.getName());
        Process process = null;
        if (modelId.indexOf("_") != -1) {
            StringTokenizer st = new StringTokenizer(modelId, "_");
            modelId = st.nextToken();
        }
        try {
            process = container.createModel(modelId);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Null schema type for: " + file.getCanonicalPath(), e);
        }
        catch (ProjectException e) {
            // empty catch block
        }
        return process;
    }

    @Override
    public Process loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        Process process = this.create(container, file);
        this.load(process, file);
        if (!ProcessContent.isDefaultProcess((Process)process)) {
            DocumentationFileLoader.loadDocumentationFor(process, file);
        }
        return process;
    }

    @Override
    public Process loadObject(@NotNull InputStream in) throws ProjectException {
        ModelFormat contentLoader = ModelFormat.Extension.get(SchemaType.PROCESS);
        Process process = this.getProject().createEmptyModel("");
        contentLoader.parse(in, this.getProject(), process, false);
        return process;
    }

    private void load(Process content, VFile file) throws ProjectException {
        try {
            this.loadXPDLCompliantModel(content, file);
        }
        catch (ModelParseException modelParseException) {
            try {
                this.load57Model(content, file);
            }
            catch (Throwable t) {
                throw ProjectException.wrap((ProjectObject)content, t);
            }
        }
    }

    private void loadXPDLCompliantModel(Process mutableModel, VFile file) throws ProjectException {
        String value = DefaultModelFormat.getLanguageNameSpace(file);
        if (value == null) {
            this.load57Model(mutableModel, file);
        } else {
            this.loadModel(mutableModel, file);
        }
    }

    private void load57Model(Process mutableModel, VFile file) throws ProjectException {
        this.loadModel(mutableModel, file);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadModel(Process mutableModel, VFile file) throws ProjectException {
        ModelFormat contentLoader = ModelFormat.Extension.get(SchemaType.PROCESS);
        VFileInputStream fileInputStream = null;
        Object bufferedInputStream = null;
        try {
            fileInputStream = new VFileInputStream(file);
            contentLoader.parse((InputStream)fileInputStream, this.getProject(), mutableModel, false);
        }
        catch (FileNotFoundException e) {
            try {
                throw ProjectException.wrap((ProjectObject)mutableModel, e);
                catch (IOException e2) {
                    throw ProjectException.wrap((ProjectObject)mutableModel, e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(new Closeable[]{fileInputStream});
                StreamUtils.close(bufferedInputStream);
                throw throwable;
            }
        }
        StreamUtils.close(new Closeable[]{fileInputStream});
        StreamUtils.close(bufferedInputStream);
    }
}

