/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.holidays.FixedHoliday;
import oracle.bpm.holidays.Holiday;
import oracle.bpm.holidays.HolidayCalendar;
import oracle.bpm.holidays.YearApplicableHoliday;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.lang.Day;
import oracle.bpm.lang.Month;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.WorkDaySchedule;
import oracle.bpm.lang.WorkWeek;
import oracle.bpm.project.OrganizationalUnitRefImpl;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.identity.ApplicationRole;
import oracle.bpm.project.model.identity.Group;
import oracle.bpm.project.model.identity.MemberContainer;
import oracle.bpm.project.model.identity.User;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.OrganizationalUnitRef;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.organization.OrganizationImpl;
import oracle.bpm.services.organization.model.ApplicationRoleType;
import oracle.bpm.services.organization.model.ApplicationRoles;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.CalendarRules;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.HolidayRules;
import oracle.bpm.services.organization.model.HolidayType;
import oracle.bpm.services.organization.model.MemberType;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.OrganizationalUnits;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.WorkPeriodType;
import oracle.bpm.services.organization.model.WorkdayType;
import oracle.bpm.xmlparser.ParserException;
import org.jetbrains.annotations.NotNull;

@ProjectObjectLoaderMetadata(objectClasses={Organization.class})
public class OrganizationLoader
extends ProjectObjectLoader<Organization> {
    private static JAXBContext jaxbContext;

    @Override
    public Organization create(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        return new OrganizationImpl(this.getProject());
    }

    @Override
    public Organization loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        Organization organization = this.create(container, file);
        organization.setId("organization");
        try {
            VFileInputStream is = new VFileInputStream(file);
            this.loadObject(organization, (InputStream)is);
        }
        catch (IOException e) {
            throw ProjectException.wrap((ProjectObject)organization, e);
        }
        return organization;
    }

    @Override
    public Organization loadObject(@NotNull InputStream in) throws ProjectException {
        OrganizationImpl organization = new OrganizationImpl(this.getProject());
        this.loadObject((Organization)organization, in);
        return organization;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadObject(Organization organization, InputStream is) throws ProjectException {
        try {
            JAXBContext jc = jaxbContext;
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            Object unmarshalledObject = unmarshaller.unmarshal(is);
            if (!(unmarshalledObject instanceof oracle.bpm.services.organization.model.Organization)) throw new ParserException("Invalid JAXB element found");
            this.load((oracle.bpm.services.organization.model.Organization)unmarshalledObject, organization);
        }
        catch (ParserException e) {
            try {
                throw ProjectException.wrap((ProjectObject)organization, e);
                catch (JAXBException e2) {
                    throw ProjectException.wrap((ProjectObject)organization, e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(is);
                throw throwable;
            }
        }
        StreamUtils.close(is);
    }

    private void load(oracle.bpm.services.organization.model.Organization tOrganization, Organization organization) throws ProjectException {
        if (tOrganization.isSetApplicationRoles()) {
            this.addRoles(tOrganization.getApplicationRoles(), organization);
        }
        if (tOrganization.isSetOrganizationalUnits()) {
            this.addOrganizationalUnits(tOrganization.getOrganizationalUnits(), organization);
        }
        if (!Str.isEmpty(tOrganization.getProcessOrganizationalUnitId())) {
            OrganizationalUnitRefImpl ouMappingRef = new OrganizationalUnitRefImpl(tOrganization.getProcessOrganizationalUnitId(), tOrganization.getProcessOrganizationalUnitName(), organization.getProject());
            organization.getOrganizationalChart().setOrganizationalUnitMapping((OrganizationalUnitRef)ouMappingRef);
        }
        if (tOrganization.isSetHolidayRules()) {
            this.addHolidayRules(tOrganization.getHolidayRules(), organization);
        }
        if (tOrganization.isSetCalendarRules()) {
            this.addCalendarRules(tOrganization.getCalendarRules(), organization);
        }
    }

    private void addRoles(ApplicationRoles applicationRoles, Organization organization) throws ProjectException {
        for (ApplicationRoleType applicationRoleType : applicationRoles.getApplicationRole()) {
            String roleName;
            String roleId;
            if (applicationRoleType.getProcessRole() != null) {
                roleId = applicationRoleType.getProcessRole().getId();
                roleName = applicationRoleType.getProcessRole().getName();
            } else {
                roleId = applicationRoleType.getId();
                roleName = applicationRoleType.getName();
            }
            Role role = organization.createRole(roleId == null ? roleName : roleId, roleName);
            role.setName(roleName);
            List members = applicationRoleType.getMember();
            for (PrincipleRefType principleRefType : members) {
                this.addMember(role, principleRefType);
            }
            organization.addChild(role);
        }
        if (organization.findChild(Role.class, "ProcessOwner") == null) {
            Role processOwnerRole = organization.createRole("ProcessOwner", "Process Owner");
            organization.addChild(processOwnerRole);
        }
    }

    private void addOrganizationalUnits(OrganizationalUnits tOrganizationalUnits, Organization organization) throws ProjectException {
        OrganizationalChart organizationalChart = organization.getOrganizationalChart();
        for (OrganizationalUnit tOu : tOrganizationalUnits.getOrganizationalUnit()) {
            oracle.bpm.project.model.organization.OrganizationalUnit ouParent = null;
            if (tOu.getParentOrganizationalUnitId() != null) {
                ouParent = this.findOrCreate(tOu.getParentOrganizationalUnitId(), tOrganizationalUnits.getOrganizationalUnit(), organization);
            }
            OrganizationalUnit.Mutable ou = organizationalChart.createOrganizationalUnit(tOu.getOrganizationalUnitId(), ouParent).asMutable();
            ou.setName(tOu.getOrganizationalUnitName());
            ou.setDescription(tOu.getDescription());
            for (MemberType tMemberType : tOu.getMember()) {
                this.addMember(ou, (PrincipleRefType)tMemberType);
            }
            ou.setCalendarRule(tOu.getCalendarRuleId());
            organizationalChart.addChild(ou);
        }
    }

    private oracle.bpm.project.model.organization.OrganizationalUnit findOrCreate(String parentOrganizationalUnitId, List<OrganizationalUnit> tOrganizationalUnits, Organization organization) {
        oracle.bpm.project.model.organization.OrganizationalUnit organizationalUnit = organization.findOrganizationalUnit(parentOrganizationalUnitId);
        if (organizationalUnit == null) {
            for (OrganizationalUnit unit : tOrganizationalUnits) {
                if (!unit.getOrganizationalUnitId().equals(parentOrganizationalUnitId)) continue;
                organizationalUnit = this.findOrCreate(unit.getOrganizationalUnitId(), tOrganizationalUnits, organization);
            }
        }
        return organizationalUnit;
    }

    private void addMember(MemberContainer memberContainer, PrincipleRefType principleRefType) throws ProjectException {
        ParticipantTypeEnum type = principleRefType.getType();
        if (type == ParticipantTypeEnum.USER) {
            User user = memberContainer.createUser(principleRefType.getName());
            user.setName(principleRefType.getName());
            user.setRealm(principleRefType.getRealm());
            memberContainer.addUser(user);
        } else if (type == ParticipantTypeEnum.GROUP) {
            Group group = memberContainer.createGroup(principleRefType.getName());
            group.setName(principleRefType.getName());
            group.setRealm(principleRefType.getRealm());
            memberContainer.addGroup(group);
        } else {
            ApplicationRole applicationRole = memberContainer.createApplicationRole(principleRefType.getName());
            applicationRole.setName(principleRefType.getName());
            applicationRole.setApplicationContext(principleRefType.getApplicationContext());
            memberContainer.addApplicationRole(applicationRole);
        }
    }

    private void addHolidayRules(HolidayRules tHolidayRules, Organization organization) throws ProjectException {
        for (HolidayRule tHr : tHolidayRules.getHolidayRule()) {
            HolidayRule.Mutable holidayRule = organization.createHolidayRule(tHr.getId()).asMutable();
            Holiday[] holidays = new Holiday[tHr.getHolidays().size()];
            int i = 0;
            for (HolidayType tHolidayType : tHr.getHolidays()) {
                Holiday holiday;
                oracle.bpm.holidays.HolidayType holidayType = oracle.bpm.holidays.HolidayType.fromValue((String)tHolidayType.getHolidayPattern().value());
                Time time = Time.valueOf(tHolidayType.getHolidayDate().toGregorianCalendar().getTime());
                holidays[i] = holiday = holidayType == oracle.bpm.holidays.HolidayType.YEAR_APPLICABLE ? YearApplicableHoliday.valueOf((Time)time, (String)tHolidayType.getName()) : FixedHoliday.valueOf((int)time.getDay(), (Month)Month.valueOf(time.getMonth()), (String)tHolidayType.getName());
                ++i;
            }
            holidayRule.setName(tHr.getName());
            holidayRule.setHolidayCalendar(new HolidayCalendar(holidays));
            organization.addChild(holidayRule);
        }
    }

    private void addCalendarRules(CalendarRules tCalendarRules, Organization organization) throws ProjectException {
        for (CalendarRule tCalendarRule : tCalendarRules.getCalendarRule()) {
            CalendarRule.Mutable calendarRule = organization.createCalendarRule(tCalendarRule.getId()).asMutable();
            calendarRule.setTimeZone(tCalendarRule.getTimeZone());
            calendarRule.setHolidayRule(tCalendarRule.getHolidayRuleId());
            WorkWeek workWeek = new WorkWeek();
            for (WorkdayType tWorkday : tCalendarRule.getWorkdayList().getWorkday()) {
                Day day = Day.valueOf(tWorkday.getWeekDay().toString());
                WorkDaySchedule workDaySchedule = new WorkDaySchedule();
                int i = 0;
                for (WorkPeriodType tWorkPeriod : tWorkday.getWorkPeriod()) {
                    XMLGregorianCalendar startCalendar = tWorkPeriod.getStartTime();
                    XMLGregorianCalendar endCalendar = tWorkPeriod.getEndTime();
                    int startTime = startCalendar.getHour() * 100 + startCalendar.getMinute();
                    int endTime = endCalendar.getHour() * 100 + endCalendar.getMinute();
                    workDaySchedule.setShift(i, startTime, endTime);
                    ++i;
                }
                workWeek.setSchedule(day, workDaySchedule);
            }
            calendarRule.setName(tCalendarRule.getName());
            calendarRule.setWorkWeek(workWeek);
            organization.addChild(calendarRule);
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

