/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import fuego.simulation.ModelSimulationProcessImpl;
import fuego.simulation.ModelSimulationsContainerImpl;
import fuego.simulation.ProjectSimulationsContainerImpl;
import fuego.simulation.SimulationsContainerImpl;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.project.FolderContainerImpl;
import oracle.bpm.project.UndeletableFolderContainerImpl;
import oracle.bpm.project.XSLTransformationsContainerImpl;
import oracle.bpm.project.activityguide.ActivityGuidesContainerImpl;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.ModelSimulationsContainer;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

@ProjectObjectLoaderMetadata(objectClasses={FolderContainer.class})
public class FolderContainerLoader
extends ProjectObjectLoader<FolderContainer> {
    @Override
    public FolderContainer create(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        if (this.isSimulationsContainer(file)) {
            return new SimulationsContainerImpl(this.getProject(), container, file.getName());
        }
        if (this.isSimulationDefinitionsContainer(file)) {
            return new ProjectSimulationsContainerImpl(this.getProject(), container, file.getName());
        }
        if (this.isSimulationModelsContainer(file)) {
            return new ModelSimulationsContainerImpl(this.getProject(), container, file.getName());
        }
        if (this.isModelSimulationProcess(container)) {
            return new ModelSimulationProcessImpl(this.getProject(), container, file.getName());
        }
        if (this.isActivityGuidesContainer(file)) {
            return new ActivityGuidesContainerImpl(this.getProject(), container, file.getName());
        }
        if (this.isXSLTransformationsContainer(file)) {
            return new XSLTransformationsContainerImpl(this.getProject(), container, file.getName());
        }
        if (this.isModelContainer(file)) {
            return new UndeletableFolderContainerImpl(this.getProject(), container, file.getName());
        }
        return new FolderContainerImpl(this.getProject(), container, file.getName());
    }

    @Override
    public FolderContainer loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        return this.create(container, file);
    }

    private boolean isModelContainer(@NotNull VFile file) {
        VFile root = file.getFileSystem().getRoot();
        return file.equals((Object)Path.PROCESSES.getVFile(root));
    }

    private boolean isSimulationsContainer(@NotNull VFile file) {
        VFile root = file.getFileSystem().getRoot();
        return file.equals((Object)Path.SIMULATIONS.getVFile(root));
    }

    private boolean isActivityGuidesContainer(VFile file) {
        VFile root = file.getFileSystem().getRoot();
        return file.equals((Object)Path.ACTIVITY_GUIDES.getVFile(root));
    }

    private boolean isSimulationModelsContainer(@NotNull VFile file) {
        VFile root = file.getFileSystem().getRoot();
        return file.equals((Object)Path.SIMULATIONS_MODELS.getVFile(root));
    }

    private boolean isSimulationDefinitionsContainer(@NotNull VFile file) {
        VFile root = file.getFileSystem().getRoot();
        return file.equals((Object)Path.SIMULATIONS_DEFINITIONS.getVFile(root));
    }

    private boolean isModelSimulationProcess(@NotNull ResourceContainer container) {
        return container instanceof ModelSimulationsContainer;
    }

    private boolean isXSLTransformationsContainer(VFile file) {
        VFile root = file.getFileSystem().getRoot();
        return file.equals((Object)Path.XSL.getVFile(root));
    }
}

