/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.io.serializers.organization.ParseListener;
import oracle.bpm.project.io.serializers.organization.ProjectFileHandlerFactory;
import oracle.bpm.project.io.serializers.organization.ProjectObjectParser;
import oracle.bpm.project.io.serializers.organization.ProjectSourceHandler;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.variables.BusinessParameter;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@ProjectObjectLoaderMetadata(objectClasses={BusinessParameter.class})
public class BusinessParameterLoader
extends ProjectObjectLoader<BusinessParameter> {
    private SAXParser saxParser;

    public BusinessParameterLoader() {
        try {
            this.saxParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            Log.logDebug(e);
        }
        catch (SAXException e) {
            Log.logDebug(e);
        }
    }

    @Override
    public BusinessParameter loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        return this.create(container, file);
    }

    @Override
    public BusinessParameter create(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        BusinessParameter businessParameter;
        VFileInputStream in = null;
        try {
            in = new VFileInputStream(file);
            businessParameter = this.loadObject(container, (InputStream)in);
        }
        catch (IOException e) {
            try {
                throw ProjectException.wrap((ProjectObject)container, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(new Closeable[]{in});
                throw throwable;
            }
        }
        StreamUtils.close(new Closeable[]{in});
        return businessParameter;
    }

    @Override
    public BusinessParameter loadObject(@NotNull InputStream in) throws ProjectException {
        return this.loadObject((ResourceContainer)this.getProject().getBusinessParametersContainer(), in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private BusinessParameter loadObject(ResourceContainer container, InputStream fileInputStream) {
        final ProjectObject[] newProjectObject = new ProjectObject[]{null};
        try {
            InputSource inputSource = new InputSource(fileInputStream);
            ProjectSourceHandler handler = ProjectFileHandlerFactory.createProjectHandler(this.getProject(), container);
            handler.addParseListener(new ParseListener(){

                @Override
                public void objectParsed(ProjectObjectParser parser, ProjectObject projectObject) throws ProjectException {
                    newProjectObject[0] = projectObject;
                }

                @Override
                public ProjectObject getObjectParsed() {
                    return null;
                }

                @Override
                public ProjectObjectParser getProjectObjectParser() {
                    return null;
                }
            });
            this.saxParser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (IOException e) {
            e.printStackTrace();
            StreamUtils.close(fileInputStream);
        }
        catch (SAXException e2) {
            block6: {
                if (e2.getException() == null) break block6;
                e2.initCause(e2.getException());
                {
                    catch (Throwable throwable) {
                        StreamUtils.close(fileInputStream);
                        throw throwable;
                    }
                }
            }
            StreamUtils.close(fileInputStream);
        }
        StreamUtils.close(fileInputStream);
        return (BusinessParameter)newProjectObject[0];
    }
}

