/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.export;

import oracle.bpm.project.io.fs.export.ExcludeAllLibrariesFilterBuilder;
import oracle.bpm.project.io.fs.export.ExportFileFilterBuilder;
import oracle.bpm.project.io.fs.export.IncludeAllLibrariesFilterBuilder;
import oracle.bpm.project.io.fs.export.IncludeVersionableLibrariesFilterBuilder;

public enum ExportType {
    EXCLUDE_ALL_LIBRARIES("None_type", new ExcludeAllLibrariesFilterBuilder()),
    INCLUDE_ONLY_VERSIONABLE_LIBRARIES("Enterprise_type", new IncludeVersionableLibrariesFilterBuilder()),
    INCLUDE_ALL_LIBRARIES("Express_type", new IncludeAllLibrariesFilterBuilder());

    private String name;
    private ExportFileFilterBuilder exportFilterBuilder;

    private ExportType(String name, ExportFileFilterBuilder builder) {
        this.name = name;
        this.exportFilterBuilder = builder;
    }

    public String getName() {
        return this.name;
    }

    public static ExportType getExportTypeByName(String name) {
        for (ExportType exportType : ExportType.values()) {
            if (!exportType.getName().equals(name)) continue;
            return exportType;
        }
        return null;
    }

    public ExportFileFilterBuilder getExportFilterBuilder() {
        return this.exportFilterBuilder;
    }

    public static ExportType getDefault() {
        return INCLUDE_ALL_LIBRARIES;
    }
}

