/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.export;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.project.io.fs.filter.CompositeFileFilter;
import oracle.bpm.project.io.fs.filter.VCSFilesFilter;
import oracle.bpm.project.model.LocalFileSystem;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectLoader;

public class ExportFileFilter
extends CompositeFileFilter {
    private List<FileFilter> filters = new ArrayList<FileFilter>();
    private List<File> ignoreFiles = new ArrayList<File>();

    public ExportFileFilter(ProjectLoader projectLoader) {
        this.initFilters(projectLoader.getProject());
        this.initIgnoreFiles(projectLoader);
    }

    @Override
    public boolean accept(File pathname) {
        if (this.ignoreFiles.contains(pathname)) {
            return false;
        }
        for (FileFilter fileFilter : this.filters) {
            if (fileFilter.accept(pathname)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addFilter(oracle.bpm.project.io.fs.filter.FileFilter fileFilter) {
        if (fileFilter != null) {
            this.filters.add(fileFilter);
        }
    }

    private void initIgnoreFiles(ProjectLoader projectLoader) {
        LocalFileSystem localFileSystem = projectLoader.getProjectFileSystem().getLocalFileSystem();
        this.ignoreFiles.add(localFileSystem.getBuildFolder());
        this.ignoreFiles.add(localFileSystem.getSystemFolder());
    }

    private void initFilters(Project project) {
        this.filters.add(new VCSFilesFilter());
    }
}

