/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.AbstractChangeManager;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.util.FileUtils;

public class PresentationChangeManager
extends AbstractChangeManager {
    protected PresentationChangeManager(AbstractProjectRepository repository, Project project) {
        super(repository, project);
    }

    public static AbstractChangeManager create(AbstractProjectRepository repository, Project project) {
        return new PresentationChangeManager(repository, project);
    }

    @Override
    public boolean isValid(File resourceFile) {
        return resourceFile.isFile() && ".xprdl".equals(FileUtils.getExtension((File)resourceFile));
    }

    @Override
    protected boolean addProjectObject(ProjectObject presentation) throws ProjectException {
        this.getProject().getPresentationManager().addPresentation((Presentation)presentation);
        return false;
    }

    @Override
    protected ProjectObject getProjectObject(File resourceFile) {
        return this.getProject().getPresentationManager().getPresentation(FileUtils.getName((File)resourceFile));
    }

    @Override
    protected ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.PRESENTATION;
    }

    @Override
    protected boolean replaceProjectObject(ProjectObject newPresentation) throws ProjectException {
        Presentation oldPresentation = this.getProject().getPresentationManager().findChild(Presentation.class, newPresentation.getId());
        this.getProject().getPresentationManager().replaceChild(oldPresentation, newPresentation);
        return false;
    }
}

