/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.AbstractOrganizationChangeManager;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.util.FileUtils;

public class ParticipantChangeManager
extends AbstractOrganizationChangeManager {
    private ParticipantChangeManager(AbstractProjectRepository repository, Project project) {
        super(repository, project);
    }

    public static ParticipantChangeManager create(AbstractProjectRepository repository, Project project) {
        return new ParticipantChangeManager(repository, project);
    }

    @Override
    public boolean isValid(File resourceFile) {
        return resourceFile.isFile() && ".xpadl".equals(FileUtils.getExtension((File)resourceFile));
    }

    @Override
    protected boolean addProjectObject(ProjectObject projectObject) throws ProjectException {
        if (this.getOrganization().findParticipant(projectObject.getId()) == null) {
            super.getOrganization().addOrganizationalObject(projectObject);
        }
        return false;
    }

    @Override
    protected ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.PARTICIPANT;
    }

    @Override
    protected ProjectObject getProjectObject(File resourceFile) {
        return super.getOrganization().findParticipant(FileUtils.getName((File)resourceFile));
    }

    @Override
    protected boolean replaceProjectObject(ProjectObject projectObject) throws ProjectException {
        super.getProject().replace(projectObject);
        return false;
    }
}

