/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.AbstractOrganizationChangeManager;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.util.FileUtils;

public class GroupChangeManager
extends AbstractOrganizationChangeManager {
    private GroupChangeManager(AbstractProjectRepository repository, Project project) {
        super(repository, project);
    }

    public static GroupChangeManager create(AbstractProjectRepository repository, Project project) {
        return new GroupChangeManager(repository, project);
    }

    @Override
    public boolean isValid(File resourceFile) {
        return resourceFile.isFile() && ".xgdl".equals(FileUtils.getExtension((File)resourceFile));
    }

    @Override
    protected boolean addProjectObject(ProjectObject projectObject) throws ProjectException {
        if (this.getOrganization().findGroup(projectObject.getId()) == null) {
            super.getOrganization().addOrganizationalObject(projectObject);
        }
        return false;
    }

    @Override
    protected ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.ORGANIZATION_GROUP;
    }

    @Override
    protected ProjectObject getProjectObject(File resourceFile) {
        return super.getOrganization().findGroup(FileUtils.getName((File)resourceFile));
    }

    @Override
    protected boolean replaceProjectObject(ProjectObject projectObject) throws ProjectException {
        super.getProject().replace(projectObject);
        return false;
    }
}

