/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.ChangeManager;
import oracle.bpm.project.io.fs.events.ChangeManagers;
import oracle.bpm.project.io.fs.events.FileChangeEvent;
import oracle.bpm.project.io.fs.events.FileChangeVisitor;
import oracle.bpm.project.model.Project;

public class FileChangeVisitorImpl
implements FileChangeVisitor {
    private ChangeManagers changeManagers;

    public FileChangeVisitorImpl(AbstractProjectRepository repository, Project project) {
        this.changeManagers = ChangeManagers.create(repository, project);
    }

    @Override
    public void visit(FileChangeEvent fileChangeEvent) {
        ChangeManager changeManager = this.changeManagers.getChangeManager(fileChangeEvent.getResource());
        switch (fileChangeEvent.getType()) {
            case FILE_ADDED: {
                changeManager.add(fileChangeEvent.getResource());
                break;
            }
            case FILE_CHANGED: {
                changeManager.change(fileChangeEvent.getResource());
            }
            case FILE_REMOVED: {
                changeManager.delete(fileChangeEvent.getResource());
            }
        }
    }
}

