/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.AbstractExternalResourceChangeManager;
import oracle.bpm.project.model.ExternalResource;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.util.FileUtils;

public class ExternalResourceChangeManager
extends AbstractExternalResourceChangeManager {
    private ExternalResourceChangeManager(AbstractProjectRepository repository, Project project) {
        super(repository, project);
    }

    public static ExternalResourceChangeManager create(AbstractProjectRepository repository, Project project) {
        return new ExternalResourceChangeManager(repository, project);
    }

    @Override
    public boolean isValid(File resourceFile) {
        return resourceFile.isFile() && this.isValidFileExtension(resourceFile) && this.isIntoExternalResourcesFolder(resourceFile);
    }

    @Override
    protected boolean addProjectObject(ProjectObject projectObject) throws ProjectException {
        if (this.getProject().findDeclaredExternalResource(projectObject.getId()) == null) {
            super.getProject().addExternalResource((ExternalResource)projectObject);
        }
        return false;
    }

    @Override
    protected ProjectObject getProjectObject(File resourceFile) {
        return super.getProject().findDeclaredExternalResource(FileUtils.getName((File)resourceFile));
    }

    @Override
    protected ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.EXTERNAL_RESOURCE;
    }

    @Override
    protected boolean replaceProjectObject(ProjectObject projectObject) throws ProjectException {
        super.getProject().replace(projectObject);
        return false;
    }

    private boolean isValidFileExtension(File resourceFile) {
        return ".xml".equals("." + FileUtils.getExtension((File)resourceFile));
    }

    private boolean isIntoExternalResourcesFolder(File resourceFile) {
        return false;
    }
}

