/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import java.io.IOException;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.log.Log;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.ObjectsHandledRegisterInterface;
import oracle.bpm.project.io.fs.events.ChangeManager;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ProjectException;

public abstract class AbstractChangeManager
implements ChangeManager {
    private Project project;
    private AbstractProjectRepository repository;

    protected AbstractChangeManager(AbstractProjectRepository repository, Project project) {
        this.project = project;
        this.repository = repository;
    }

    @Override
    public boolean add(File resourceFile) {
        boolean result = false;
        if (this.isProjectObjectLoaded()) {
            boolean wasLoaded = false;
            try {
                ProjectObject objectToAdd;
                for (ProjectObject objectWritten : this.getObjectsRegister().getObjectsWrittenFromEclipse()) {
                    File objectWrittenFile = this.getResourceFileForObject(objectWritten);
                    if (!resourceFile.equals(objectWrittenFile)) continue;
                    wasLoaded = true;
                    this.getObjectsRegister().removeObjectWrittenFromEclipse(objectWritten);
                    break;
                }
                if (!wasLoaded && (objectToAdd = null) != null) {
                    this.getObjectsRegister().addObjectWrittenFromOutside(objectToAdd);
                    result = this.addProjectObject(objectToAdd);
                }
            }
            catch (ProjectException e) {
                Log.logTrace(e);
            }
        }
        return result;
    }

    @Override
    public boolean change(File resourceFile) {
        boolean result = false;
        if (this.isProjectObjectLoaded()) {
            boolean wasLoaded = false;
            try {
                ProjectObject objectChanged;
                for (ProjectObject objectWritten : this.getObjectsRegister().getObjectsWrittenFromEclipse()) {
                    File objectWrittenFile = this.getResourceFileForObject(objectWritten);
                    if (!resourceFile.equals(objectWrittenFile)) continue;
                    wasLoaded = true;
                    this.getObjectsRegister().removeObjectWrittenFromEclipse(objectWritten);
                    break;
                }
                if (!wasLoaded && (objectChanged = null) != null) {
                    this.getObjectsRegister().addObjectWrittenFromOutside(objectChanged);
                    result = this.replaceProjectObject(objectChanged);
                }
            }
            catch (ProjectException e) {
                Log.logTrace(e);
            }
        }
        return result;
    }

    @Override
    public boolean delete(File resourceFile) {
        boolean result = false;
        if (this.isProjectObjectLoaded()) {
            boolean wasDeleted = false;
            try {
                ProjectObject objectToRemove;
                for (ProjectObject objectDeletedByEclipse : this.getObjectsRegister().getObjectsDeletedFromEclipse()) {
                    File objectDeletedFile = this.getResourceFileForObject(objectDeletedByEclipse);
                    if (!resourceFile.equals(objectDeletedFile)) continue;
                    wasDeleted = true;
                    this.getObjectsRegister().removeObjectDeletedFromEclipse(objectDeletedByEclipse);
                    break;
                }
                if (!wasDeleted && (objectToRemove = this.getProjectObject(resourceFile)) != null) {
                    this.getObjectsRegister().addObjectDeletedFromOutside(objectToRemove);
                    result = this.removeProjectObject(objectToRemove);
                }
            }
            catch (ProjectException e) {
                Log.logTrace(e);
            }
        }
        return result;
    }

    protected abstract ProjectObjectType getProjectObjectType();

    protected abstract boolean addProjectObject(ProjectObject var1) throws ProjectException;

    protected abstract boolean replaceProjectObject(ProjectObject var1) throws ProjectException;

    protected abstract ProjectObject getProjectObject(File var1);

    protected boolean removeProjectObject(ProjectObject projectObject) throws ProjectException {
        projectObject.delete();
        return true;
    }

    protected ProjectLoader getLoader() {
        return this.project.getLoader();
    }

    protected boolean isProjectObjectLoaded() {
        return false;
    }

    protected ProjectWriter getWriter() {
        return this.project.getWriter();
    }

    protected FuegoProject getProject() {
        return (FuegoProject)this.project;
    }

    protected AbstractProjectRepository getRepository() {
        return this.repository;
    }

    protected void debug(String text) {
    }

    protected ObjectsHandledRegisterInterface getObjectsRegister() {
        return null;
    }

    protected File getResourceFileForObject(ProjectObject projectObject) throws ProjectException {
        try {
            VFile file = this.project.getWriter().getFile(projectObject);
            VFileSystem fs = file.getFileSystem();
            if (fs instanceof JavaFileSystem) {
                return ((JavaFileSystem)fs).toJavaFile(file);
            }
            return null;
        }
        catch (IOException e) {
            throw ProjectException.wrap(projectObject, e);
        }
    }
}

