/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.util.FileUtils;
import oracle.bpm.util.JarWrapper;

public class WebRoot {
    public static final String WEBROOT_DIRECTORY = "webRoot";
    public static final String RESOURCES_DIRECTORY = "webResources";
    public static final String JSP_DIRECTORY = "customJSP";
    private static final String JSP_EXTENSION = ".JSP";
    private static final String JSPF_EXTENSION = ".JSPF";
    private static final String JSF_EXTENSION = ".JSF";

    public static File getJSPDir(ProjectWriter projectWriter) {
        File jspDirectory = new File(projectWriter.getProjectFileSystem().getLocalFileSystem().getRootFolder(), WEBROOT_DIRECTORY + File.separator + JSP_DIRECTORY);
        if (!jspDirectory.exists()) {
            jspDirectory.mkdirs();
        }
        return jspDirectory;
    }

    public static File[] getJSPFiles(ProjectWriter fileSystem) {
        List files = FileUtils.getFilesRecursively((File)WebRoot.getJSPDir(fileSystem), (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File file) {
                String extension = FileUtils.getExtension((File)file);
                return WebRoot.JSP_EXTENSION.equalsIgnoreCase(extension) || WebRoot.JSPF_EXTENSION.equalsIgnoreCase(extension) || WebRoot.JSF_EXTENSION.equalsIgnoreCase(extension);
            }
        });
        return files.toArray(new File[0]);
    }

    public static File getResourcesDir(ProjectWriter projectWriter) {
        File resourcesDirectory = new File(projectWriter.getProjectFileSystem().getLocalFileSystem().getRootFolder(), WEBROOT_DIRECTORY + File.separator + RESOURCES_DIRECTORY);
        if (!resourcesDirectory.exists()) {
            resourcesDirectory.mkdirs();
        }
        return resourcesDirectory;
    }

    public static File[] getWebResourceFiles(ProjectWriter projectWriter) {
        List files = FileUtils.getFilesRecursively((File)WebRoot.getResourcesDir(projectWriter), (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() || file.list().length != 0;
            }
        });
        return files.toArray(new File[0]);
    }

    public static File getWebRootDir(ProjectWriter projectWriter) {
        File rootDirectory = new File(projectWriter.getProjectFileSystem().getLocalFileSystem().getRootFolder(), WEBROOT_DIRECTORY);
        if (!rootDirectory.exists()) {
            rootDirectory.mkdirs();
        }
        return rootDirectory;
    }

    public static void copyWebRootTo(ProjectWriter projectWriter, File dest) {
        FileUtils.deleteDirectory((File)new File(dest, WEBROOT_DIRECTORY));
        FileUtils.copyFileOrDirectory((File)WebRoot.getWebRootDir(projectWriter), (File)new File(dest, WEBROOT_DIRECTORY));
    }

    public static void createCustomJspJar(ProjectWriter projectWriter, String jarFile) throws IOException {
        WebRoot.createJar(jarFile, WebRoot.getJSPDir(projectWriter));
    }

    public static void createWebResourceJar(ProjectWriter projectWriter, String jarFile) throws IOException {
        WebRoot.createJar(jarFile, WebRoot.getResourcesDir(projectWriter));
    }

    public static void createWebRootJar(ProjectWriter projectWriter, String jarFile) throws IOException {
        WebRoot.createJar(jarFile, WebRoot.getWebRootDir(projectWriter));
    }

    public static String getJspUrlFolder() {
        return new StringBuffer().append("/").append(WEBROOT_DIRECTORY).append("/").append(JSP_DIRECTORY).toString();
    }

    public static String getWebResourcesUrlFolder() {
        return new StringBuffer().append("/").append(WEBROOT_DIRECTORY).append("/").append(RESOURCES_DIRECTORY).toString();
    }

    private static void createJar(String jarFile, File directoryRoot) throws IOException {
        File f = new File(jarFile);
        if (f.exists()) {
            f.delete();
        }
        JarWrapper jar = JarWrapper.createJar((String)jarFile);
        jar.addDirectoryTree(directoryRoot, null, true);
        jar.flush();
        jar.close();
    }
}

