/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs;

import java.io.File;
import oracle.bpm.adapter.DefaultAdapterFactory;
import oracle.bpm.adapter.annotation.Adapter;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.NoSuchComponentTypeException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.catalog.ComponentBundle;
import oracle.bpm.type.catalog.DirectoryComponentBundle;

@Adapter
public class TypeFileAdapterFactory
extends DefaultAdapterFactory {
    public TypeFileAdapterFactory() {
        super(TypeRef.class, File.class);
    }

    @Override
    public <T> T adapt(Object adaptableObject, Class<T> targetType) {
        ComponentCatalog catalog;
        File result = null;
        TypeRef typeRef = (TypeRef)adaptableObject;
        TypeDescription type = typeRef.get();
        if (targetType == File.class && (catalog = type.getCatalog()) instanceof MutableComponentCatalog) {
            MutableComponentCatalog repository = (MutableComponentCatalog)catalog;
            try {
                ComponentBundle bundle = repository.getComponentBundleForType(type.getText());
                File baseDir = bundle != null ? bundle.getBasePath() : null;
                result = DirectoryComponentBundle.getFileForType((File)baseDir, (String)type.getText());
            }
            catch (NoSuchComponentTypeException e) {
                result = null;
            }
        }
        return targetType.cast(result);
    }
}

