/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.model.LocalFileSystem;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.dashboard.WidgetModel;
import oracle.bpm.project.model.forms.Form;
import org.jetbrains.annotations.NotNull;

public class ProjectFileSystemImpl
implements ProjectFileSystem {
    private VFileSystem dataFileSystem;
    private Map<Class<? extends ProjectObject>, VFile> folderMap = new HashMap<Class<? extends ProjectObject>, VFile>();
    private LocalFileSystem localFileSystem;

    private ProjectFileSystemImpl(VFileSystem dataFileSystem, File localRootFolder) {
        this.dataFileSystem = dataFileSystem;
        this.localFileSystem = LocalFileSystemImpl.create(localRootFolder);
        this.buildFolderMap();
    }

    public static ProjectFileSystem create(VFileSystem dataFileSystem, File localRootFolder) {
        return new ProjectFileSystemImpl(dataFileSystem, localRootFolder);
    }

    @Override
    public VFileSystem getDataFileSystem() {
        return this.dataFileSystem;
    }

    @Override
    public VFile getDefaultFolder(@NotNull Class<? extends ProjectObject> projectClass) {
        return this.folderMap.get(projectClass);
    }

    @Override
    public LocalFileSystem getLocalFileSystem() {
        return this.localFileSystem;
    }

    private void buildFolderMap() {
        this.folderMap.put(WidgetModel.class, Path.WIDGETS.getVFile(this.dataFileSystem.getRoot()));
        this.folderMap.put(Form.class, Path.FORMS.getVFile(this.dataFileSystem.getRoot()));
    }

    private static class LocalFileSystemImpl
    implements LocalFileSystem {
        private File localRootFolder;

        private LocalFileSystemImpl(File localRootFolder) {
            this.localRootFolder = localRootFolder;
        }

        public static LocalFileSystem create(File localRootFolder) {
            return new LocalFileSystemImpl(localRootFolder);
        }

        @Override
        public File getBuildFolder() {
            return this.getFile(Path.BUILD);
        }

        @Override
        public File getBuildCatalogFolder() {
            return this.getFile(Path.BUILD_CATALOG);
        }

        @Override
        public File getBuildProcessesFolder() {
            return this.getFile(Path.BUILD_PROCESSES);
        }

        @Override
        public File getSystemFolder() {
            return this.getFile(Path.SYSTEM);
        }

        @Override
        public File getSystemConfigFolder() {
            return this.getFile(Path.SYSTEM_CONFIG);
        }

        @Override
        public File getExternalResourcesFolder() {
            return this.getFile(Path.EXTERNAL_RESOURCES);
        }

        @Override
        public File getProcessesFolder() {
            return this.getFile(Path.PROCESSES);
        }

        @Override
        public File getLibFolder() {
            return this.getFile(Path.LIB);
        }

        @Override
        public File getRootFolder() {
            return this.localRootFolder;
        }

        private File getFile(Path path) {
            return path.getFile(this.getRootFolder());
        }
    }
}

