/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.collections.Sequence;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VEventType;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileEvent;
import oracle.bpm.io.fs.VFileEventListener;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.catalog.bundles.CommonTypesComponentBundle;
import oracle.bpm.project.catalog.bundles.ProjectCatalogComponentBundle;
import oracle.bpm.project.catalog.bundles.SystemFaultsComponentBundle;
import oracle.bpm.project.catalog.composite.CompositeAccessor;
import oracle.bpm.project.catalog.composite.CompositeAccessorFactory;
import oracle.bpm.project.io.fs.ProjectObjectsCache;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.io.serializers.organization.presentation.ProjectPresentationLoader;
import oracle.bpm.project.io.serializers.organization.view.ProjectViewLoader;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.ResourceFilesContainer;
import oracle.bpm.project.model.XSLTransformationsContainer;
import oracle.bpm.project.model.catalog.CatalogAdapter;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.BpelProcess;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.dataassociations.XSLTransformation;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.catalog.CatalogListener;
import oracle.bpm.type.catalog.ComponentBundle;
import oracle.bpm.util.ProgressMonitor;
import oracle.bpm.view.io.PresentationLoader;
import oracle.bpm.view.io.ViewLoader;
import org.jetbrains.annotations.NotNull;

public class FileProjectLoader
implements ProjectLoader {
    private PresentationLoader presentationLoader;
    private Project project;
    private ProjectFileSystem projectFileSystem;
    private ProjectObjectsCache projectObjectsCache;
    private ProjectRepository repository;
    private ViewLoader viewLoader;
    private static final String COMPONENT_TYPE = ".componentType";
    private static final String BPEL = ".bpel";
    private static final String XSL = ".xsl";
    public static InheritableThreadLocal<Boolean> processingCatalogEvent = new InheritableThreadLocal();

    public FileProjectLoader(ProjectRepository repository, Project project, ProjectFileSystem fileSystem) {
        this.repository = repository;
        this.project = project;
        this.projectFileSystem = fileSystem;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public ProjectFileSystem getProjectFileSystem() {
        return this.projectFileSystem;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Serializable loadSystemObject(String id) throws ProjectException {
        Serializable serializable;
        ObjectInputStream ois;
        FileInputStream stream;
        block8: {
            stream = null;
            ois = null;
            File file = new File(this.getProjectFileSystem().getLocalFileSystem().getSystemFolder(), id + ".ser");
            if (!file.exists()) break block8;
            stream = new FileInputStream(file);
            ois = new ObjectInputStream(stream);
            Serializable serializable2 = (Serializable)ois.readObject();
            StreamUtils.close(ois);
            StreamUtils.close(stream);
            return serializable2;
        }
        try {
            serializable = null;
        }
        catch (FileNotFoundException e) {
            Serializable serializable3 = null;
            {
                catch (Throwable throwable) {
                    StreamUtils.close(ois);
                    StreamUtils.close(stream);
                    throw throwable;
                }
            }
            StreamUtils.close(ois);
            StreamUtils.close(stream);
            return serializable3;
            catch (IOException e2) {
                throw ProjectException.wrap(e2);
                catch (ClassNotFoundException e3) {
                    throw ProjectException.wrap(e3);
                }
            }
        }
        StreamUtils.close(ois);
        StreamUtils.close(stream);
        return serializable;
    }

    @Override
    public <P extends ProjectObject> List<P> getAllObjects(@NotNull Class<P> objectClass) throws ProjectException {
        assert (objectClass != Process.class) : "Model cannot be retreived with getAllObjects until FolderContainer has been removed. Use getChildren instead";
        List<Object> result = !this.isPersistent() ? Collections.emptyList() : this.getProjectObjectsCache().getAllObjects(objectClass);
        return result;
    }

    @Override
    public <P extends ProjectObject> P getObject(@NotNull ResourceContainer container, @NotNull Class<P> objectClass, @NotNull String id) throws ProjectException {
        return this.getProjectObjectsCache().getObject(container, objectClass, id);
    }

    @Override
    public <T extends ProjectObject> T createFromXml(Class<T> objectClass, String xml) throws ProjectException {
        try {
            byte[] bytes = xml.getBytes(Literals.DEFAULT_ENCODING);
            ProjectObjectLoader loader = ProjectObjectLoader.create(objectClass, this.getProject());
            Object object = loader.loadObject(new ByteArrayInputStream(bytes));
            return (T)((ProjectObject)objectClass.cast(object));
        }
        catch (UnsupportedEncodingException e) {
            throw ProjectException.wrap(null, e);
        }
        catch (ProjectException e) {
            throw ProjectException.wrap(null, e);
        }
    }

    @Override
    public <P extends ProjectObject> P reloadObject(@NotNull P object) throws ProjectException {
        return this.getProjectObjectsCache().reloadObject(object);
    }

    @Override
    public List<ProjectObject> getChildren(@NotNull ResourceContainer container) throws ProjectException {
        return this.getProjectObjectsCache().getChildren(container);
    }

    @Override
    public <P extends ProjectObject> List<P> getChildrenByType(@NotNull ResourceContainer container, @NotNull Class<P> objectClass) throws ProjectException {
        return this.getProjectObjectsCache().getChildrenByType(container, objectClass);
    }

    @Override
    public List<VFile> getAllFiles(@NotNull Class<? extends ProjectObject> objectClass) throws ProjectException {
        return this.projectObjectsCache.getAllFiles(objectClass);
    }

    @Override
    public ProjectRepository getProjectRepository() {
        return this.repository;
    }

    @Override
    public void loadCatalog(ProgressMonitor monitor) throws ProjectException {
        final FuegoProject project = (FuegoProject)this.getProject();
        MutableComponentCatalog defaultCatalog = project.getDefaultCatalog();
        final MutableComponentCatalog projectCatalog = TypeUtils.createComponentCatalog((MutableComponentCatalog)defaultCatalog);
        projectCatalog.setOwner((Object)project);
        projectCatalog.setDescription(project.getName());
        ProjectFileSystem fileSystem = project.getLoader().getProjectFileSystem();
        VFileSystem dataFileSystem = fileSystem.getDataFileSystem();
        projectCatalog.addComponentBundle((ComponentBundle)new SystemFaultsComponentBundle());
        CommonTypesComponentBundle commonTypesComponentBundle = new CommonTypesComponentBundle((ComponentCatalog)projectCatalog, dataFileSystem);
        projectCatalog.addComponentBundle((ComponentBundle)commonTypesComponentBundle);
        CompositeAccessor controller = CompositeAccessorFactory.createCompositeAccessor((Project)project);
        ProjectCatalogComponentBundle projectCatalogComponentBundle = new ProjectCatalogComponentBundle(controller, projectCatalog, dataFileSystem);
        projectCatalog.addComponentBundle((ComponentBundle)projectCatalogComponentBundle);
        projectCatalog.setDefaultStorageBundle((ComponentBundle)projectCatalogComponentBundle);
        projectCatalog.sync();
        projectCatalog.getRoot();
        projectCatalog.addListener((CatalogListener)new CatalogAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void typeAdded(String typeName) {
                try {
                    TypeRef type = projectCatalog.find(typeName);
                    if (type == null) {
                        throw new IllegalArgumentException("Unable to find typeName '" + typeName + "' on the catalog");
                    }
                    CatalogObjectImpl parent = FileProjectLoader.this.findParent(type, project);
                    try {
                        processingCatalogEvent.set(true);
                        parent.childAddedFromCatalog(type);
                    }
                    finally {
                        processingCatalogEvent.set(false);
                    }
                }
                catch (AmbiguousTypeNameException e) {
                    assert (false) : e;
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void typeRemoved(String typeName) {
                CatalogObjectImpl parent = FileProjectLoader.this.findParent(typeName, project);
                if (parent != null) {
                    try {
                        parent.childRemovedFromCatalog(typeName);
                    }
                    catch (ProjectException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        project.setComponentCatalog((ComponentCatalog)projectCatalog);
        this.listenForExternalChanges(dataFileSystem);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void replaceProjectObject(ProjectObject projectObject) throws ProjectException {
        if (ProjectObjectType.BPM_OBJECT.equals((Object)projectObject.getProjectObjectType())) {
            ObjectTypeDescription typeRef = ((CatalogObject)projectObject).getObjectType();
            typeRef.getCatalog().reload((TypeRef)typeRef);
        } else {
            ProjectObjectContainer container = (ProjectObjectContainer)projectObject.getParentObject();
            ProjectObject newObject = this.reloadObject(projectObject);
            container.replaceChild(projectObject, newObject);
        }
    }

    @Override
    public void loadDashboards() throws ProjectException {
    }

    @Override
    public ViewLoader getViewLoader() {
        if (this.viewLoader == null) {
            this.viewLoader = new ProjectViewLoader(this.getProject());
        }
        return this.viewLoader;
    }

    @Override
    public PresentationLoader getPresentationLoader() {
        if (this.presentationLoader == null) {
            this.presentationLoader = new ProjectPresentationLoader(this.getProject());
        }
        return this.presentationLoader;
    }

    ProjectObjectsCache getProjectObjectsCache() throws ProjectException {
        try {
            if (this.projectObjectsCache == null) {
                this.projectObjectsCache = new ProjectObjectsCache(this.getProjectFileSystem().getDataFileSystem(), this.getProject());
            }
            return this.projectObjectsCache;
        }
        catch (IOException e) {
            throw ProjectException.wrap((ProjectObject)this.getProject(), e);
        }
    }

    private void listenForExternalChanges(final VFileSystem fs) {
        fs.addListener(new VFileEventListener(){

            public void onFileEvent(@NotNull VFileEvent event) {
                VFile file = event.getSource();
                String path = file.getCanonicalPath();
                if (path.endsWith(FileProjectLoader.COMPONENT_TYPE) || path.endsWith(FileProjectLoader.BPEL)) {
                    FileProjectLoader.this.checkForBpelProcesses(path, fs);
                } else if (path.endsWith(FileProjectLoader.XSL)) {
                    if (event.getType() == VEventType.ADD) {
                        FileProjectLoader.this.checkForAddedXsls(path, fs);
                    } else if (event.getType() == VEventType.REMOVE) {
                        FileProjectLoader.this.checkForDeletedXsls();
                    }
                } else if (event.getType() == VEventType.REMOVE) {
                    try {
                        ProjectObjectContainer parent;
                        ProjectObject object = FileProjectLoader.this.getProjectObjectsCache().getObject(file);
                        if (object != null && (parent = (ProjectObjectContainer)object.getParentObject()) != null && parent.contains(object)) {
                            parent.removeChild(object);
                        }
                    }
                    catch (ProjectException e) {
                        e.printStackTrace();
                    }
                } else if (event.getType() == VEventType.ADD) {
                    // empty if block
                }
            }
        });
    }

    private void checkForBpelProcesses(String path, VFileSystem fs) {
        String relatedPath = path.replace(COMPONENT_TYPE, BPEL);
        VFile relatedFile = fs.createFile(relatedPath);
        try {
            this.getProjectObjectsCache().resync(relatedFile);
            List<BpelProcess> bpelProcesses = this.getProject().getLoader().getChildrenByType(this.getProject(), BpelProcess.class);
            for (BpelProcess bpelProcess : bpelProcesses) {
                if (this.getProject().contains(bpelProcess)) continue;
                this.project.addChild(bpelProcess);
            }
            Sequence<BpelProcess> processes = this.getProject().getChildrenByType(BpelProcess.class);
            for (BpelProcess process : processes) {
                if (bpelProcesses.contains(process)) continue;
                this.getProject().removeChild(process);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
    }

    private void checkForDeletedXsls() {
        ResourceFilesContainer resources = this.getProject().getResourceFilesContainer();
        XSLTransformationsContainer xsls = resources.getXSLTransformationsContainer();
        Sequence<XSLTransformation> all = xsls.getDescendants(XSLTransformation.class);
        ArrayList<XSLTransformation> delete = new ArrayList<XSLTransformation>();
        for (XSLTransformation xsl : all) {
            VFile vFile = ((Adaptable)((Object)xsl)).as(VFile.class);
            try {
                if (vFile == null || vFile.exists()) continue;
                delete.add(xsl);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (XSLTransformation xslTransformation : delete) {
            try {
                xslTransformation.delete();
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
    }

    private void checkForAddedXsls(String path, VFileSystem fs) {
        VFile relatedFile = fs.createFile(path);
        ResourceFilesContainer resources = this.getProject().getResourceFilesContainer();
        XSLTransformationsContainer xsls = resources.getXSLTransformationsContainer();
        try {
            this.getProjectObjectsCache().resync(((Adaptable)((Object)xsls)).as(VFile.class));
            List<XSLTransformation> bpelProcesses = this.getProject().getLoader().getChildrenByType(xsls, XSLTransformation.class);
            for (XSLTransformation xslTransformation : bpelProcesses) {
                if (xsls.contains(xslTransformation)) continue;
                xsls.addChild(xslTransformation);
            }
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isPersistent() {
        return this.projectFileSystem != null;
    }

    private CatalogObjectImpl findParent(String typeName, FuegoProject project) {
        CatalogObject object = project.findExistingCatalogObject(typeName);
        return object == null ? null : this.getParent(project, object);
    }

    private CatalogObjectImpl findParent(TypeRef typeRef, FuegoProject project) {
        CatalogObject object = CatalogObjectImpl.create((Project)project, (TypeRef)typeRef);
        return this.getParent(project, object);
    }

    private CatalogObjectImpl getParent(FuegoProject project, CatalogObject object) {
        ProjectObject parentObject = object.getParentObject();
        if (!(parentObject instanceof CatalogObjectImpl)) {
            parentObject = CatalogObjectImpl.create((Project)project, (TypeRef)project.getComponentCatalog().getRoot());
        }
        return (CatalogObjectImpl)parentObject;
    }
}

