/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import oracle.bpm.configuration.BaseConfiguration;
import oracle.bpm.configuration.BaseFileManager;
import oracle.bpm.configuration.ConfigurationSet;
import oracle.bpm.io.FileSystem;
import oracle.bpm.project.model.ExternalResource;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryAdapter;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.util.FileUtils;
import org.jetbrains.annotations.Nullable;

public class FileConfigurationManager
extends BaseFileManager<ExternalResource> {
    private ProjectListener<ExternalResource> externalResourceListener;
    private final File file;
    private Project project;

    private FileConfigurationManager(ConfigurationSet<ExternalResource> configurationSet, File externalResourceFolder, FileSystem fileSystem, Project project) {
        super(configurationSet, fileSystem);
        this.file = externalResourceFolder;
        super.setReadOnly(this.getFile().exists() && !this.getFile().canWrite());
        this.project = project;
        this.addProjectListener();
        this.addRepositoryListener();
    }

    public void configRemoved(ExternalResource configuration) {
        super.configRemoved((BaseConfiguration)configuration);
        File configFile = new File(this.file, configuration.getName() + ".xml");
        if (!configFile.exists()) {
            configFile = FileUtils.changeFileName((File)configFile, (String)(FileUtils.getName((File)configFile) + "ExtRes"));
        }
        configFile.delete();
    }

    protected File getFile() {
        return this.file;
    }

    @Nullable
    protected InputStream reloadData() throws Exception {
        return this.file.exists() ? new FileInputStream(this.file) : null;
    }

    protected void saveConfigurations() throws Exception {
        this.configurations.writeXML(this.file);
    }

    protected boolean internalSaveConfiguration(ExternalResource externalResource) {
        return false;
    }

    private void addRepositoryListener() {
        ProjectRepository projectRepository = this.project.getLoader().getProjectRepository();
        projectRepository.addRepositoryListener(new RepositoryAdapter(){

            @Override
            public void preProjectClose(Project project) {
                FileConfigurationManager.this.removeExternalResourceListener();
            }

            @Override
            public void projectDeleted(Project project) {
                FileConfigurationManager.this.removeExternalResourceListener();
            }
        });
    }

    private void addProjectListener() {
        this.externalResourceListener = new ProjectListenerAdapter<ExternalResource>(ExternalResource.class){

            @Override
            public void postObjectAdded(ExternalResource externalResource, ProjectObject parent) {
                FileConfigurationManager.this.configurations.addEntry((BaseConfiguration)externalResource);
            }

            @Override
            public void objectChanged(ExternalResource externalResource, ProjectEvent event) {
                FileConfigurationManager.this.configurations.removeEntry(externalResource.getName());
                FileConfigurationManager.this.configurations.addEntry((BaseConfiguration)externalResource);
            }

            @Override
            public void postObjectRemoved(ExternalResource externalResource, ProjectObject parent) {
                FileConfigurationManager.this.configurations.removeEntry(externalResource.getName());
            }
        };
        this.project.addListener(this.externalResourceListener);
    }

    private void removeExternalResourceListener() {
        this.project.removeListener(this.externalResourceListener);
    }
}

