/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.log.Log;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.ProjectResourceObjectFactory;
import oracle.bpm.project.activityguide.ActivityGuideImpl;
import oracle.bpm.project.io.mem.MemoryProjectLoader;
import oracle.bpm.project.io.mem.MemoryProjectWriter;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.events.RepositoryListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.organization.OrganizationImpl;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.util.ObjectWatch;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractProjectRepository
implements ProjectRepository {
    protected Map<String, Project> projectsMap = new TreeMap<String, Project>();
    protected List<RepositoryListener> repositoryListeners = new ArrayList<RepositoryListener>();
    private boolean disposed;
    private Map<String, Object> options = new HashMap<String, Object>();
    private boolean readOnly;
    private static FuegoProject defaultProject;
    private static WeakHashMap<ProjectRepository, String> createdRepositories;

    protected AbstractProjectRepository() {
        createdRepositories.put(this, "");
    }

    @Override
    public void open(@NotNull Project project) throws ProjectException {
        if (!this.existsProject(project.getName())) {
            throw new ProjectException(project, Msg.QUOTE("Project " + project.getName() + " was not created in Project Repository"));
        }
        project.setOpen(true);
        this.fireProjectOpened(project);
    }

    @Override
    public final Collection<Project> getAllProjects() {
        return this.projectsMap.values();
    }

    @Override
    public final Project getProject(String projectName) {
        return this.projectsMap.get(projectName);
    }

    @Override
    public void close(Project project) throws ProjectException {
        this.firePreCloseProject(project);
        project.setOpen(false);
        this.fireProjectClosed(project);
    }

    @Override
    public void dispose() {
        Collection<Project> projects = this.getAllProjects();
        for (Project project : projects) {
            try {
                if (project.isOpen()) {
                    this.close(project);
                }
                project.dispose();
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public Project create(@NotNull URI baseLocation, @NotNull String projectName) throws ProjectException {
        Project project = this.createInternal(baseLocation, projectName);
        ProjectFileSystem fileSystem = this.createFileSystem(project, baseLocation);
        this.initProject(project, fileSystem);
        return project;
    }

    @Override
    public Project create(@NotNull Project projectSource, @NotNull URI baseLocation, @NotNull String projectName) throws ProjectException {
        File targetLocation = new File(new File(baseLocation), projectName);
        this.copyProjectTo(projectSource, targetLocation);
        return this.create(baseLocation, projectName);
    }

    @Override
    public void delete(@NotNull Project project) throws ProjectException {
        String name = project.getName();
        this.close(project);
        project.dispose();
        this.projectsMap.remove(name);
        this.fireProjectDeleted(project);
    }

    @Override
    public final boolean existsProject(String projectName) {
        return this.projectsMap.containsKey(projectName);
    }

    @Override
    public final Collection<Project> getOpenedProjects() {
        ArrayList<Project> result = new ArrayList<Project>();
        for (Project project : this.projectsMap.values()) {
            if (!project.isOpen()) continue;
            result.add(project);
        }
        return result;
    }

    @Override
    public final boolean isOpen(@NotNull Project project) {
        return project.isOpen();
    }

    @Override
    public void refresh(Project project) throws ProjectException {
    }

    @Override
    public void setOption(String name, Object value) {
        this.options.put(name, value);
    }

    @Override
    public Object getOption(String name) {
        return this.options.get(name);
    }

    @Override
    public final Project getDefaultProject() {
        if (defaultProject == null) {
            defaultProject = FuegoProject.create((String)"__Default__");
            defaultProject.setRepository((ProjectRepository)this);
            defaultProject.setComponentCatalog((ComponentCatalog)TypeUtils.getDefaultCatalog());
            defaultProject.setLoader((ProjectLoader)new MemoryProjectLoader((Project)defaultProject, this));
            defaultProject.setWriter((ProjectWriter)new MemoryProjectWriter((Project)defaultProject));
        }
        return defaultProject;
    }

    @Override
    public final boolean addRepositoryListener(RepositoryListener listener) {
        boolean result = false;
        if (!this.repositoryListeners.contains(listener)) {
            result = this.repositoryListeners.add(listener);
        }
        return result;
    }

    @Override
    public final boolean removeRepositoryListener(RepositoryListener listener) {
        return this.repositoryListeners.remove(listener);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected abstract ProjectFileSystem createFileSystem(Project var1, URI var2) throws ProjectException;

    protected abstract ProjectLoader createLoader(Project var1, @NotNull ProjectFileSystem var2) throws ProjectException;

    protected abstract ProjectWriter createWriter(Project var1, @NotNull ProjectFileSystem var2) throws ProjectException;

    protected Project createInternal(@NotNull URI baseLocation, @NotNull String projectName) throws ProjectException {
        if (this.existsProject(projectName)) {
            throw new ProjectException(null, ProjectMsg.PROJECT_DIR_ALREADY_EXISTS);
        }
        FuegoProject project = FuegoProject.create((String)projectName);
        project.setRepository((ProjectRepository)this);
        return project;
    }

    protected void initProject(Project project, ProjectFileSystem fileSystem) throws ProjectException {
        ProjectLoader loader = this.createLoader(project, fileSystem);
        ProjectWriter writer = this.createWriter(project, fileSystem);
        project.setLoader(loader);
        project.setWriter(writer);
        this.createProjectStructure(project, fileSystem);
        this.createProjectFiles(project, fileSystem);
        this.projectsMap.put(project.getName(), project);
        this.fireProjectCreated(project);
        this.open(project);
        this.openDependency(project);
    }

    protected void createProjectFiles(Project project, ProjectFileSystem fileSystem) throws ProjectException {
        this.createActivityGuide(project);
        this.createProjectModel(project);
        this.createOrganization(project);
        this.createProjectPreferences(project);
    }

    protected final void fireProjectCreated(Project project) {
        for (RepositoryListener repositoryListener : new ArrayList<RepositoryListener>(this.repositoryListeners)) {
            repositoryListener.projectCreated(project);
        }
    }

    protected final void fireProjectOpened(Project project) {
        for (RepositoryListener repositoryListener : new ArrayList<RepositoryListener>(this.repositoryListeners)) {
            repositoryListener.projectOpened(project);
        }
    }

    protected final void fireProjectClosed(Project project) {
        for (RepositoryListener repositoryListener : new ArrayList<RepositoryListener>(this.repositoryListeners)) {
            try {
                repositoryListener.projectClosed(project);
            }
            catch (Exception e) {
                Log.logSevere(e);
            }
        }
    }

    protected final void fireProjectDeleted(Project project) {
        for (RepositoryListener repositoryListener : new ArrayList<RepositoryListener>(this.repositoryListeners)) {
            try {
                repositoryListener.projectDeleted(project);
            }
            catch (Exception e) {
                Log.logSevere(e);
            }
        }
    }

    protected final void firePreCloseProject(Project project) {
        for (RepositoryListener repositoryListener : new ArrayList<RepositoryListener>(this.repositoryListeners)) {
            try {
                repositoryListener.preProjectClose(project);
            }
            catch (Exception e) {
                Log.logSevere(e);
            }
        }
    }

    protected final void fireProjectDisposed(Project project) {
        for (RepositoryListener repositoryListener : new ArrayList<RepositoryListener>(this.repositoryListeners)) {
            try {
                repositoryListener.projectDisposed(project);
            }
            catch (Exception e) {
                Log.logSevere(e);
            }
        }
    }

    protected void createProjectStructure(Project project, ProjectFileSystem fileSystem) throws ProjectException {
        VFileSystem dataFileSystem = fileSystem.getDataFileSystem();
        ArrayList<VFile> list = new ArrayList<VFile>();
        list.add(dataFileSystem.createFile(Path.PROCESSES.getName()));
        list.add(dataFileSystem.createFile(Path.RESOURCES.getName()));
        VFile config = dataFileSystem.createFile(Path.CONFIG.getName());
        list.add(config);
        list.add(dataFileSystem.createFile(Path.BUSINESS_PARAMETER.getName()));
        list.add(dataFileSystem.createFile(Path.BUSINESS_CATALOG.getName()));
        VFile simulations = dataFileSystem.createFile(Path.SIMULATIONS.getName());
        list.add(simulations);
        list.add(dataFileSystem.createFile(simulations, Path.SIMULATIONS_DEFINITIONS.getName()));
        list.add(dataFileSystem.createFile(simulations, Path.SIMULATIONS_MODELS.getName()));
        list.add(dataFileSystem.createFile(Path.LIB.getName()));
        list.add(dataFileSystem.createFile(Path.XSL.getName()));
        for (VFile vFile : list) {
            try {
                if (vFile.exists()) continue;
                vFile.mkdirs();
            }
            catch (IOException e) {
                throw ProjectException.wrap((ProjectObject)project, e);
            }
        }
    }

    protected void openDependency(Project project) throws ProjectException {
        List<String> list;
        ProjectPreferences preferences = project.getPreferences();
        if (preferences != null && !(list = preferences.getDependencies()).isEmpty()) {
            String id = list.get(0);
            Project parentProject = this.getProject(id);
            if (parentProject != null) {
                if (!parentProject.isOpen()) {
                    this.open(parentProject);
                }
            } else {
                parentProject = this.create(id);
            }
        }
    }

    private void createActivityGuide(Project project) throws ProjectException {
        ProjectLoader loader = project.getLoader();
        VFileSystem dataFileSystem = loader.getProjectFileSystem().getDataFileSystem();
        VFile vFile = dataFileSystem.createFile("activityGuide.agdl");
        try {
            if (!vFile.exists()) {
                ActivityGuideImpl activityGuide = new ActivityGuideImpl(project, "activityGuide");
                ProjectObjectImpl.adaptProjectObject((ProjectObjectImpl)activityGuide, (Object)vFile);
                project.getWriter().write(new ProjectObject[]{activityGuide});
            }
        }
        catch (IOException e) {
            throw ProjectException.wrap((ProjectObject)project, e);
        }
    }

    private void createOrganization(Project project) throws ProjectException {
        ProjectLoader loader = project.getLoader();
        VFileSystem dataFileSystem = loader.getProjectFileSystem().getDataFileSystem();
        VFile vFile = dataFileSystem.createFile("organization.xml");
        try {
            if (!vFile.exists()) {
                OrganizationImpl organization = new OrganizationImpl(project);
                ProjectObjectImpl.setAdapter((ProjectObject)organization, (Object)vFile);
                project.getWriter().write(new ProjectObject[]{organization});
            }
        }
        catch (IOException e) {
            throw ProjectException.wrap((ProjectObject)project, e);
        }
    }

    private void copyProjectTo(@NotNull Project project, @NotNull File destinationFile) throws ProjectException {
        try {
            ProjectLoader loader = project.getLoader();
            assert (loader != null);
            VFileSystem vFileSystem = loader.getProjectFileSystem().getDataFileSystem();
            VFile source = vFileSystem.getRoot();
            destinationFile.mkdirs();
            JavaFileSystem destination = new JavaFileSystem(destinationFile);
            VFile vFile = destination.createFile("classes");
            vFile.mkdirs();
            VFileUtils.dirCopy((VFile)source, (VFile)destination.getRoot(), (VFileFilter)new VFileFilter(){

                public boolean accept(@NotNull VFile pathname) throws IOException {
                    return !"project.lock".equals(pathname.getName());
                }
            });
            VFile[] files = destination.list(destination.getRoot(), new VFileFilter(){

                public boolean accept(@NotNull VFile pathname) throws IOException {
                    return pathname.getName().endsWith(".jpr");
                }
            });
            VFile oldVFile = vFileSystem.createFile(destinationFile.getName() + ".jpr");
            if (!oldVFile.exists()) {
                String name = project.getName();
                String replacement = destinationFile.getName();
                VFileUtils.Filter filter = VFileUtils.Filter.Factory.replaceAll((String)name, (String)replacement);
                VFile oldProjectJpr = vFileSystem.createFile(name + ".jpr");
                if (oldProjectJpr.exists()) {
                    VFile newJpr = destination.createFile(destinationFile.getName() + ".jpr");
                    VFileUtils.copyFileFiltering((VFile)oldProjectJpr, (VFile)newJpr, (VFileUtils.Filter)filter);
                    for (VFile file : files) {
                        file.delete();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ProjectException(project, Msg.QUOTE("Problems while copying the project."), e);
        }
    }

    private void createProjectPreferences(Project project) throws ProjectException {
        ProjectLoader loader = project.getLoader();
        VFileSystem dataFileSystem = loader.getProjectFileSystem().getDataFileSystem();
        VFile config = dataFileSystem.createFile(Path.CONFIG.getName());
        String name = "preferences.xml";
        VFile vFile = dataFileSystem.createFile(config, name);
        try {
            if (!vFile.exists()) {
                ProjectPreferences preferences = project.createProjectPreferences("preferences");
                ProjectObjectImpl.setAdapter((ProjectObject)preferences, (Object)vFile);
                project.getWriter().write(preferences);
            }
        }
        catch (IOException e) {
            throw ProjectException.wrap((ProjectObject)project, e);
        }
    }

    private void createProjectModel(Project project) throws ProjectException {
        ProjectLoader loader = project.getLoader();
        VFileSystem dataFileSystem = loader.getProjectFileSystem().getDataFileSystem();
        String id = "default";
        VFile vFile = dataFileSystem.createFile(id + ".bpmn");
        try {
            if (!vFile.exists()) {
                Process rootProcess = ProjectResourceObjectFactory.createProjectProcess((Project)project, (String)id, (boolean)true);
                ProjectObjectImpl.setAdapter((ProjectObject)rootProcess, (Object)vFile);
                project.getWriter().write(rootProcess);
            }
        }
        catch (IOException e) {
            throw ProjectException.wrap((ProjectObject)project, e);
        }
    }

    static {
        createdRepositories = new WeakHashMap();
        ObjectWatch.register((String)"project", (String)"repositories", (String)"repositories", createdRepositories);
    }
}

