/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Id;
import oracle.bpm.project.model.exception.ProjectException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractPreferencesLoader
extends DefaultHandler {
    private final String encoding;
    private final File file;
    private int fileVersion = -1;

    protected AbstractPreferencesLoader(File file) {
        this(file, "UTF-8");
    }

    protected AbstractPreferencesLoader(File file, String encoding) {
        this.file = file;
        this.encoding = encoding;
    }

    public int getFileVersion() {
        return this.fileVersion;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() throws ProjectException {
        if (!this.file.exists()) {
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(true);
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(this);
            fileInputStream = new FileInputStream(this.file);
            reader.parse(new InputSource(fileInputStream));
        }
        catch (ParserConfigurationException e) {
            try {
                throw ProjectException.wrap(e);
                catch (IOException e2) {
                    throw ProjectException.wrap(e2);
                }
                catch (SAXException e3) {
                    throw ProjectException.wrap(e3);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(fileInputStream);
                throw throwable;
            }
        }
        StreamUtils.close(fileInputStream);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (target.equals("fuego")) {
            this.fileVersion = Id.parseXmlVersion(data);
        }
    }
}

