/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class UnboundEventCommand
extends MultipleCommand {
    private final Activity activity;
    private final Event event;

    public UnboundEventCommand(@NotNull Event event) {
        super(new ProjectObject[0]);
        this.event = event;
        this.activity = ModelUtils.getAssociatedFlowNode(event).asAnyNode(Activity.class);
        this.buildMultipleCommand();
    }

    @Override
    public ProjectObject getAffectedObject() {
        return this.event;
    }

    private void buildMultipleCommand() {
        this.addCommand(new ProjectCommand(new ProjectObject[0]){

            @Override
            public String getName() {
                return ProjectCommandMsg.UNBOUND_EVENT.getString();
            }

            public Object execute() {
                UnboundEventCommand.this.event.toCatch(UnboundEventCommand.this.event.getEventTriggerType());
                return null;
            }

            @Override
            public void undo() {
                UnboundEventCommand.this.event.toBoundary(UnboundEventCommand.this.event.getEventTriggerType(), UnboundEventCommand.this.activity);
            }
        });
        this.addCommand(new AddTransitionCommand(this.createTransitionToBeAdded()));
    }

    @NotNull
    private SequenceFlow createTransitionToBeAdded() {
        return this.event.getProcess().createSequenceFlow(this.activity, this.event);
    }
}

