/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.MoveFlowNodeCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Grid;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class TranslateLaneCommand
extends MultipleCommand {
    private int offset;
    private int previous;

    public TranslateLaneCommand(@NotNull Lane lane, @NotNull Point offset) {
        super(lane);
        this.previous = lane.getOffset();
        this.offset = this.getOffsetForLocation(offset);
        this.build();
    }

    public TranslateLaneCommand(@NotNull Lane lane, int offset) {
        super(lane);
        this.previous = lane.getOffset();
        this.offset = offset;
        this.build();
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.MOVE_OBJECT(this.getAffectedObject().getId()).getString();
    }

    @Override
    public Lane getAffectedObject() {
        return (Lane)super.getAffectedObject();
    }

    private void build() throws ExecutionException {
        final Lane lane = this.getAffectedObject();
        for (FlowNode flowNode : lane.getActivities()) {
            this.addCommand(new MoveFlowNodeCommand(flowNode, this.getNewLocationForFlowNode(flowNode), Grid.createNull()));
        }
        this.addCommand(new ProjectCommand(new ProjectObject[0]){

            @Override
            public String getName() {
                return null;
            }

            public Object execute() throws ExecutionException {
                lane.setOffset(TranslateLaneCommand.this.offset);
                return null;
            }

            @Override
            public void undo() {
                lane.setOffset(TranslateLaneCommand.this.previous);
            }
        });
    }

    private Point getNewLocationForFlowNode(@NotNull FlowNode flowNode) {
        int delta = this.offset - this.previous;
        return ModelUtils.isHorizontal(this.getProcess()) ? flowNode.getLocation().translate(0, delta) : flowNode.getLocation().translate(delta, 0);
    }

    private int getOffsetForLocation(@NotNull Point location) {
        return ModelUtils.isHorizontal(this.getProcess()) ? location.getY() : location.getX();
    }

    private Process getProcess() {
        return this.getAffectedObject().getProcess();
    }
}

