/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.ModelObject;

public class SwitchLanesCommand
extends ProjectCommand {
    private final Lane laneFrom;
    private final Lane laneTo;
    private final SwitchOperation operation;
    private static final Comparator<Lane> LANE_BY_POSITION = new Comparator<Lane>(){

        @Override
        public int compare(Lane a, Lane b) {
            return a.getOffset() - b.getOffset();
        }
    };

    public SwitchLanesCommand(Lane laneFrom, Lane laneTo, SwitchOperation operation) {
        super(new ProjectObject[0]);
        this.laneFrom = laneFrom;
        this.laneTo = laneTo;
        this.operation = operation;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.MOVE_OBJECT(this.laneFrom.getId()).getString();
    }

    public Object execute() throws ExecutionException {
        List<Lane> orderedLanes = this.getOrderedLanes();
        int switchFrom = orderedLanes.indexOf(this.laneFrom);
        int switchTo = orderedLanes.indexOf(this.laneTo);
        if (switchFrom == -1 || switchTo == -1 || switchFrom == switchTo) {
            return false;
        }
        this.executeSwitchOperation(orderedLanes, switchFrom, switchTo);
        int i = 0;
        for (int j = 1; j < orderedLanes.size(); ++j) {
            Lane lanePrevious = orderedLanes.get(i);
            if (i == 0) {
                lanePrevious.asMutable().setOffset(0);
            }
            Lane laneToBeCorrected = orderedLanes.get(j);
            laneToBeCorrected.asMutable().setOffset(lanePrevious.getOffset() + lanePrevious.getSize());
            ++i;
        }
        return true;
    }

    private void executeSwitchOperation(List<Lane> orderedLanes, int from, int to) {
        switch (this.operation) {
            case INSERT_ABOVE: {
                orderedLanes.add(to, orderedLanes.get(from));
                orderedLanes.remove(from > to ? from + 1 : from);
                break;
            }
            case REPLACE: {
                Collections.swap(orderedLanes, from, to);
                break;
            }
            case INSERT_BELOW: {
                orderedLanes.add(to + 1, orderedLanes.get(from));
                orderedLanes.remove(from > to ? from + 1 : from);
            }
        }
    }

    private List<Lane> getOrderedLanes() {
        return CollectionUtils.sort(((ModelObject)((Object)this.laneFrom)).getProcess().getLanes(), LANE_BY_POSITION);
    }

    public static enum SwitchOperation {
        INSERT_ABOVE,
        REPLACE,
        INSERT_BELOW;

    }
}

