/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.ResizeLaneCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;

public class SwitchLaneCommand
extends ProjectCommand {
    public ResizeLaneCommand resizeLaneCommand;
    private Lane lane;
    private Lane newLane;
    private String newName;
    private String oldName;
    private String oldParamVariable;
    private String paramVariable;
    private Process process;

    public SwitchLaneCommand(Lane lane, String newName, String paramVariable) {
        super(new ProjectObject[0]);
        this.lane = lane;
        this.newName = newName;
        this.oldParamVariable = lane.getParamName();
        this.paramVariable = paramVariable;
        this.oldName = lane.getId();
    }

    @Override
    public ProjectObject getAffectedObject() {
        return this.lane;
    }

    @Override
    public String getName() {
        return ProjectModelMsg.EDIT_LANE.getString();
    }

    public Object execute() throws ExecutionException {
        this.process = this.lane.getProcess();
        this.newLane = this.process.createLane(this.newName);
        this.newLane.setParamName(this.paramVariable);
        this.newLane.setOffset(this.lane.getOffset());
        this.newLane.setSize(this.lane.getSize());
        try {
            this.process.removeChild(this.lane);
            this.process.addChild(this.newLane);
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
        this.resizeLaneCommand = new ResizeLaneCommand(this.newLane, this.newLane.getSize());
        this.resizeLaneCommand.execute();
        return null;
    }

    @Override
    public void undo() {
        this.resizeLaneCommand.undo();
        try {
            this.process.removeChild(this.newLane);
            this.process.addChild(this.lane);
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
        this.lane.asMutable().setId(this.oldName);
        this.lane.asMutable().setParamName(this.oldParamVariable);
    }
}

