/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.util.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class ShiftObjectsCommand
extends MultipleCommand {
    protected Collection<Lane> lanes;
    protected Collection<Positional> positionals;
    private Process content;
    private int location;
    private List<ProjectObject> objectsToIgnore = null;
    private boolean rescanLanes = false;
    private int shift;

    public ShiftObjectsCommand(Collection<Positional> positionals, int shift) {
        super(new ProjectObject[0]);
        this.positionals = positionals;
        this.lanes = new ArrayList<Lane>();
        this.shift = shift;
    }

    public ShiftObjectsCommand(Process content, int location, int shift) {
        super(new ProjectObject[0]);
        this.content = content;
        this.location = location;
        this.shift = shift;
        this.findObjectsToChange();
    }

    public ShiftObjectsCommand(Process content, int location, int shift, boolean rescanLanes) {
        this(content, location, shift);
        this.rescanLanes = rescanLanes;
        this.findObjectsToChange();
    }

    public ShiftObjectsCommand(Process model, int location, int shift, boolean rescanLanes, List<ProjectObject> objectsToIgnore) {
        this(model, location, shift, rescanLanes);
        this.objectsToIgnore = objectsToIgnore;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void undo() {
        boolean horizontal = ModelUtils.isHorizontal(this.content);
        for (Positional positional : this.positionals) {
            if (this.isIgnored(positional)) continue;
            int offset = this.getPositionalOffset(positional, horizontal);
            this.setPositionalOffset(positional, offset - this.shift, horizontal);
        }
    }

    @Override
    public Object execute() throws ExecutionException {
        if (this.rescanLanes) {
            for (Lane lane : this.content.getLanes()) {
                if (lane.getOffset() + lane.getSize() <= this.location) continue;
                this.lanes.add(lane);
            }
        }
        for (Lane lane : this.lanes) {
            int offset = lane.getOffset() + this.shift;
            if (offset < 0) {
                offset = 30;
            }
            if (this.isIgnored(lane)) continue;
            lane.asMutable().setOffset(offset);
        }
        boolean horizontal = ModelUtils.isHorizontal(this.content);
        for (Positional positional : this.positionals) {
            int newOffset = this.getPositionalOffset(positional, horizontal) + this.shift;
            if (newOffset < 0) {
                newOffset = 30;
            }
            if (this.isIgnored(positional)) continue;
            this.setPositionalOffset(positional, newOffset, horizontal);
        }
        return null;
    }

    private void findObjectsToChange() {
        Sequence<TextAnnotation> notes;
        this.positionals = new ArrayList<Positional>();
        this.lanes = new ArrayList<Lane>();
        boolean horizontal = ModelUtils.isHorizontal(this.content);
        if (!this.rescanLanes) {
            for (Lane lane : this.content.getLanes()) {
                Lane.Mutable mutable = lane.asMutable();
                if (mutable.getOffset() + mutable.getSize() <= this.location) continue;
                this.lanes.add(mutable);
            }
        }
        Sequence<FlowNode> nodes = this.content.getFlowNodes();
        for (FlowNode node : nodes) {
            if (this.getPositionalOffset(node, horizontal) <= this.location) continue;
            this.positionals.add(node);
        }
        Sequence<Measurement> measurements = this.content.getMeasurements();
        if (!measurements.isEmpty()) {
            for (Measurement measurement : measurements) {
                if (this.getPositionalOffset(measurement, horizontal) <= this.location) continue;
                this.positionals.add(measurement);
            }
        }
        if (!(notes = this.content.getTextAnnotations()).isEmpty()) {
            for (TextAnnotation note : notes) {
                if (this.getPositionalOffset(note, horizontal) <= this.location) continue;
                this.positionals.add(note);
            }
        }
    }

    private int getPositionalOffset(@NotNull Positional positional, boolean horizontal) {
        return horizontal ? positional.getY() : positional.getX();
    }

    private void setPositionalOffset(@NotNull Positional positional, int newOffset, boolean horizontal) {
        if (horizontal) {
            positional.setY(newOffset);
        } else {
            positional.setX(newOffset);
        }
    }

    private boolean isIgnored(ProjectObject flowElement) {
        return this.objectsToIgnore != null && ArrayUtils.contains(this.objectsToIgnore, (Object)flowElement);
    }
}

