/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.processes.Positional;
import org.jetbrains.annotations.NotNull;

public class ResizePositionalCommand
extends MultipleCommand {
    private int height;
    private Point location;
    private int prevHeight;
    private Point prevLocation;
    private int prevWidth;
    private int width;

    public ResizePositionalCommand(@NotNull Positional element, @NotNull Point location, int width, int height) {
        super(element);
        this.location = location;
        this.width = width;
        this.height = height;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.RESIZE_OBJECT(this.getAffectedObject().toString()).getString();
    }

    @Override
    public Object execute() throws ExecutionException {
        Positional positional = this.getAffectedObject();
        this.prevLocation = positional.getLocation();
        this.prevWidth = positional.getWidth();
        this.prevHeight = positional.getHeight();
        positional.setLocation(this.location);
        positional.setWidth(this.width);
        positional.setHeight(this.height);
        return null;
    }

    @Override
    public void undo() {
        Positional positional = this.getAffectedObject();
        positional.setLocation(this.prevLocation);
        positional.setWidth(this.prevWidth);
        positional.setHeight(this.prevHeight);
    }

    @Override
    public Positional getAffectedObject() {
        return (Positional)super.getAffectedObject();
    }
}

