/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.collections.Sequence;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.ChangeTargetForNoteCommand;
import oracle.bpm.project.command.design.RemoveActivityPlainCommand;
import oracle.bpm.project.command.design.RemoveAssociatedTransitionsCommand;
import oracle.bpm.project.command.design.RemoveConnectorCommand;
import oracle.bpm.project.command.design.RemoveCounterCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class RemoveActivityCommand
extends MultipleCommand {
    private final FlowNode flowNode;

    public RemoveActivityCommand(FlowNode flowNode) {
        super(flowNode);
        this.flowNode = flowNode;
        this.buildMultipleCommand();
    }

    public String toString() {
        return super.toString() + this.flowNode + "from container: " + this.flowNode.getParentObject();
    }

    private void buildMultipleCommand() {
        if (ModelUtils.canDelete(this.flowNode)) {
            this.addCommand(new RemoveActivityAndRelationsCommand(this.flowNode));
            this.removeAssociatedActivity(this.flowNode);
        }
    }

    private void removeAssociatedActivity(FlowNode flowNode) {
        FlowNode associated;
        NodeAssociationFeature feature = flowNode.getFeature(NodeAssociationFeature.class);
        if (feature != null && !flowNode.isEvent() && (associated = feature.getAssociatedNode()) != null) {
            this.addCommand(new RemoveActivityAndRelationsCommand(associated));
        }
        if (flowNode.isActivity()) {
            Activity activity = flowNode.asAnyNode(Activity.class);
            for (BoundaryEvent boundary : activity.getActivityBoundaryEvents()) {
                this.addCommand(new RemoveActivityAndRelationsCommand(boundary));
            }
        }
    }

    private static class RemoveActivityAndRelationsCommand
    extends MultipleCommand {
        private final FlowNode flowNode;

        public RemoveActivityAndRelationsCommand(@NotNull FlowNode flowNode) {
            super(new ProjectObject[0]);
            this.flowNode = flowNode;
        }

        @Override
        public Object execute() throws ExecutionException {
            this.addCommand(new RemoveAssociatedTransitionsCommand(this.flowNode));
            this.removeAssociatedConnectors(this.flowNode);
            this.removeAssociatedNotes(this.flowNode);
            this.removeAssociatedCounter(this.flowNode);
            this.addCommand(new RemoveActivityPlainCommand(this.flowNode));
            return super.execute();
        }

        private void removeAssociatedNotes(FlowNode so) {
            Sequence<TextAnnotation> notes = so.getProcess().getTextAnnotations();
            for (TextAnnotation note : notes) {
                if (note.getTarget() != so) continue;
                this.addCommand(new ChangeTargetForNoteCommand(note, null));
            }
        }

        private void removeAssociatedConnectors(FlowNode fuegoNode) {
            Sequence<ThrowEvent> connectors = fuegoNode.getProcess().getEvents(ThrowEvent.class, EventTriggerType.LINK);
            for (ThrowEvent connector : connectors) {
                NodeAssociationFeature nodeAssociationFeature = connector.getFeature(NodeAssociationFeature.class);
                if (nodeAssociationFeature.getAssociatedNode() != fuegoNode) continue;
                this.addCommand(new RemoveConnectorCommand(connector));
            }
        }

        private void removeAssociatedCounter(FlowNode fuegoNode) {
            Counter counter = ModelUtils.getCounterFor(fuegoNode);
            if (counter != null) {
                this.addCommand(new RemoveCounterCommand(counter));
            }
        }
    }
}

