/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.changeset.ModelChangeSet;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.algorithms.KoreanLayoutAlgorithm;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Grid;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class LayoutModelCommand
extends ProjectCommand {
    private ModelChangeSet backup;
    private final Grid grid;
    private final boolean optimize;

    public LayoutModelCommand(@NotNull Process process, boolean optimize) {
        this(process, Grid.createNull(), optimize);
    }

    public LayoutModelCommand(@NotNull Process process, @NotNull Grid grid, boolean optimize) {
        super(process);
        this.optimize = optimize;
        this.grid = grid;
    }

    public static Msg getMsg() {
        return ProjectCommandMsg.LAYOUT_MODEL;
    }

    @Override
    public String getName() {
        return LayoutModelCommand.getMsg().getString();
    }

    public Object execute() throws ExecutionException {
        try {
            if (!ModelUtils.isHorizontal(this.getAffectedObject())) {
                return null;
            }
            KoreanLayoutAlgorithm algorithm = new KoreanLayoutAlgorithm(this.getAffectedObject(), (Integer)this.grid.getSize().get(), this.optimize);
            ModelChangeSet changeSet = algorithm.calculateChanges();
            this.backup = changeSet.apply(this.getAffectedObject());
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
        return null;
    }

    @Override
    public void undo() {
        try {
            if (this.backup != null) {
                this.backup.apply(this.getAffectedObject());
            }
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
    }

    @Override
    public Process getAffectedObject() {
        return (Process)super.getAffectedObject();
    }
}

