/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.AddLaneCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class InsertLaneCommand
extends MultipleCommand {
    private String name;
    private int offset;
    private final String paramVar;
    private Process process;
    private int width;
    private static final int ABOVE = -1;
    private static final int BELOW = 1;

    public InsertLaneCommand(@NotNull Process process, String name, String paramVar, int offset) {
        this(process, name, paramVar, offset, 200);
    }

    public InsertLaneCommand(@NotNull Process process, String name, String paramVar, int offset, int width) {
        super(new ProjectObject[0]);
        this.process = process;
        this.name = name;
        this.paramVar = paramVar;
        this.offset = offset;
        this.width = width;
        this.build();
    }

    @Override
    public ProjectObject getAffectedObject() {
        return this.process;
    }

    private void build() {
        Lane lane = LaneUtils.getLane(this.process, this.offset);
        if (lane != null) {
            int location = this.offset;
            int where = this.whereToInsert(lane);
            switch (where) {
                case -1: {
                    location = lane.getOffset();
                    break;
                }
                case 1: {
                    location = lane.getOffset() + lane.getSize();
                }
            }
            this.addCommand(new AddLaneCommand(this.process, this.name, this.paramVar, location, this.width, false));
        } else {
            Lane lastLane = LaneUtils.getLastLane(this.process);
            int lastModelPoint = lastLane.getOffset() + lastLane.getSize();
            this.addCommand(new AddLaneCommand(this.process, this.name, this.paramVar, lastModelPoint, this.offset - lastModelPoint + 30));
        }
    }

    private int whereToInsert(@NotNull Lane lane) {
        int result = -1;
        if (this.offset > lane.getOffset() + lane.getSize() / 2) {
            result = 1;
        }
        return result;
    }
}

