/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTransitionTargetCommand
extends ProjectCommand {
    @NotNull
    private SequenceFlow flow;
    private FlowNode prevTarget;
    private FlowNode target;

    public ChangeTransitionTargetCommand(@NotNull SequenceFlow flow, @Nullable FlowNode target) {
        super(flow);
        this.flow = flow;
        this.target = target;
        this.prevTarget = flow.getTarget();
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.MOVE_TRANSITION(this.flow).getString();
    }

    public Object execute() {
        if (this.target != null) {
            ModelUtils.translateAndRotateControlPoint(this.flow, this.flow.getTarget(), this.target.getLocation());
            this.flow.setTarget(this.target);
            return true;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.flow + ", target: " + this.target;
    }

    @Override
    public void undo() {
        ModelUtils.translateAndRotateControlPoint(this.flow, this.flow.getTarget(), this.prevTarget.getLocation());
        this.flow.setTarget(this.prevTarget);
    }
}

